

AttackEasyMass = {};

Vehicle.registerJointType("EasyMass");

function AttackEasyMass.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function AttackEasyMass:load(xmlFile)		

	self.updateJoint = false;

end;

function AttackEasyMass:delete()
end;

function AttackEasyMass:getIsTurnedOnAttachedImplements()
end;

function AttackEasyMass:readStream(streamId, connection)

	self.updateJoint = streamReadBool(streamId);

end;

function AttackEasyMass:writeStream(streamId, connection)

	streamWriteBool(streamId, self.updateJoint);
	
end;

function AttackEasyMass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AttackEasyMass:keyEvent(unicode, sym, modifier, isDown)
end;

function AttackEasyMass:update(dt)
end;

function AttackEasyMass:updateTick(dt)

	if self:getIsActiveForInput() then
		self.updateJoint = true;
	end;

	UpdateJointEvent.sendEvent(self, self.updateJoint, noEventSend);

end;

function AttackEasyMass:draw()
end;

function AttackEasyMass:validateAttacherJoint(implement, jointDesc, dt)

    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;

end;



----Update Event-----

UpdateJointEvent = {};
UpdateJointEvent_mt = Class(UpdateJointEvent, Event);

InitEventClass(UpdateJointEvent, "UpdateJointEvent");

function UpdateJointEvent:emptyNew()
    local self = Event:new(UpdateJointEvent_mt);
    self.className="UpdateJointEvent";
    return self;
end;

function UpdateJointEvent:new(object, data)
    local self = UpdateJointEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function UpdateJointEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.updateJoint = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(UpdateJointEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function UpdateJointEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;

function UpdateJointEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(UpdateJointEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(UpdateJointEvent:new(vehicle, data));
	end;
end;
