-- WindrowerExtra
-- Specialization for extra windrowerfunctions
--
-- @author  Mofi (BM-Modding) & Tobias F. (John Deere 6930)
-- @date 26/06/2013
--

WindrowerExtra = {};

function WindrowerExtra.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Windrower, specializations);
end;

function WindrowerExtra:load(xmlFile)
	
	self.checkedRotationAxis = false;
	self.checkRotationAxis = Utils.getNoNil(Utils.getRadiansFromString("vehicle.animation#checkRotationAxis", 3), {0,0,0});
	self.isInTransportState = true;
	self.stopTime = nil;
	self.animation.duration = getAnimClipDuration(self.animation.animCharSet, self.animation.clip);
	self.animation.speedScaleBackUp = self.animation.speedScale;
	self.animation.offsetTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#offsetTime"), 3) * 1000;
	self.animation.runOutTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.animation#runOutTime"), 3) * 1000;
	self.animation.rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animation#rootNode"));
	
	self.unfoldWarningTime = 0;
	self.foldWarningTime = 0;

	local windrowerStartSound = getXMLString(xmlFile, "vehicle.windrowerStartSound#file");
    if windrowerStartSound ~= nil and windrowerStartSound ~= "" then
        windrowerStartSound = Utils.getFilename(windrowerStartSound, self.baseDirectory);
        self.windrowerStartSound = createSample("windrowerStartSound");
        loadSample(self.windrowerStartSound, windrowerStartSound, false);
        self.windrowerStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerStartSound#pitchOffset"), 1);
        self.windrowerStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerStartSound#volume"), 1.0);
    end;
    local windrowerStopSound = getXMLString(xmlFile, "vehicle.windrowerStopSound#file");
    if windrowerStopSound ~= nil and windrowerStopSound ~= "" then
        windrowerStopSound = Utils.getFilename(windrowerStopSound, self.baseDirectory);
        self.windrowerStopSound = createSample("windrowerStopSound");
        loadSample(self.windrowerStopSound, windrowerStopSound, false);
        self.windrowerStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehiclewindrowerStopSound#pitchOffset"), 1);
        self.windrowerStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerSound#volume"), 1.0);
    end;
	local clientSoundFile = getXMLString(xmlFile, "vehicle.windrowerAISound#file");
	if clientSoundFile ~= nil then
		clientSoundFile = Utils.getFilename(clientSoundFile, self.baseDirectory);
		self.windowerAISoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerAISound#volume"), 1.0);
        self.windowerAISoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerAISound#radius"), 50);
        self.windowerAISoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.windrowerAISound#innerRadius"), 10);
        self.windrowerAISound = createAudioSource("windrowerAISound", clientSoundFile, self.windowerAISoundRadius, self.windowerAISoundInnerRadius, self.windowerAISoundVolume, 0);
        link(self.components[1].node, self.windrowerAISound);
        setVisibility(self.windrowerAISound, false);
	end;
	self.soundOffset = 0;
end;

function WindrowerExtra:delete()
end;

function WindrowerExtra:readStream(streamId, connection)
end;

function WindrowerExtra:writeStream(streamId, connection)
end;

function WindrowerExtra:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WindrowerExtra:keyEvent(unicode, sym, modifier, isDown)
end;

function WindrowerExtra:update(dt)
	if self.unfoldWarningTime > g_currentMission.time then
		g_currentMission:addWarning(string.format(g_i18n:getText("unfoldOBJECT_warning"), self.typeDesc), 0.018, 0.033);
	end;
	if self.foldWarningTime > g_currentMission.time then
		g_currentMission:addWarning(string.format(g_i18n:getText("stopOBJECT_warning"), self.typeDesc), 0.018, 0.033);
	end;
	if self.isTurnedOn or not self.isInTransportState then	
		if self:getIsAnimationPlaying("folding") then
			self:setFoldDirection(-1);
			self.foldWarningTime = g_currentMission.time+2000;
		end;
	end;
	
	-- rotate back animation
	if not self.isTurnedOn then
		if not self.isInTransportState then	
			if not self.animationEnabled then
				enableAnimTrack(self.animation.animCharSet, 0);
				self.animationEnabled = true;
			end;
			
			if not self.checkedRotationAxis then
				local vec = self.checkRotationAxis;
				local x,y,z = getRotation(self.animation.rootNode);
				if math.abs(vec[1]-x) < 0.01 and math.abs(vec[2]-y) < 0.01 and math.abs(vec[3]-z) < 0.01 then
					setAnimTrackTime(self.animation.animCharSet, 0, 0);
					self.stopTime = g_currentMission.time+self.animation.offsetTime;
					self.checkedRotationAxis = true;
				end;
			end;
						
			if self.stopTime ~= nil then
				if self.stopTime > g_currentMission.time then
					if self.animation.speedScale/self.animation.speedScaleBackUp > 0.1 then
						local newSpeed = Utils.getMovedLimitedValues({self.animation.speedScale}, {self.animation.speedScaleBackUp}, {0}, 1, self.animation.runOutTime, dt, true);
						self.animation.speedScale = newSpeed[1];
						setAnimTrackSpeedScale(self.animation.animCharSet, 0, newSpeed[1]);
					else
						local vec = self.checkRotationAxis;
						local x,y,z = getRotation(self.animation.rootNode);
						if math.abs(vec[1]-x) < 0.01 and math.abs(vec[2]-y) < 0.01 and math.abs(vec[3]-z) < 0.01 then
							setAnimTrackTime(self.animation.animCharSet, 0, 0);
							if self.animationEnabled then
								disableAnimTrack(self.animation.animCharSet, 0);
								self.animationEnabled = false;
							end;
							self.isInTransportState = true;
						end;
					end;
				end;
			end;
		end;
	else
		setAnimTrackSpeedScale(self.animation.animCharSet, 0, self.animation.speedScaleBackUp);
		self.animation.speedScale = self.animation.speedScaleBackUp;
		setAnimTrackLoopState(self.animation.animCharSet, 0, true);
		self.isInTransportState = false;
		self.checkedRotationAxis = false;
		self.stopTime = nil;

		if self:getIsActiveForSound() then
			if self.time > self.soundOffset then
				if not self.windrowerSoundEnabled then
					playSample(self.windrowerSound, 0, self.windrowerSoundVolume, 0);
					self.windrowerSoundEnabled = true;
				end;
			else
				stopSample(self.windrowerSound);
				self.windrowerSoundEnabled = false;
			end;
		end;
    end;
end;

function WindrowerExtra:updateTick(dt)
end;

function WindrowerExtra:draw()
end;

function WindrowerExtra:onAttach(attacherVehicle)
end;

function WindrowerExtra:onDetach()
	if self.windrowerStartSound ~= nil then
		stopSample(self.windrowerStartSound);
	end;
	if self.windrowerStopSound ~= nil then
		stopSample(self.windrowerStopSound);
	end;
	if self.windrowerAISound ~= nil then
		setVisibility(self.windrowerAISound, false);
	end;
end;

function WindrowerExtra:onLeave()
	if self.windrowerStartSound ~= nil then
		stopSample(self.windrowerStartSound);
	end;
	if self.windrowerStopSound ~= nil then
		stopSample(self.windrowerStopSound);
	end;
	if self.windrowerAISound ~= nil then
		setVisibility(self.windrowerAISound, false);
	end;
end;

function WindrowerExtra:setIsTurnedOn(isTurnedOn, noEventSend)
	local soundOffset = 0;
	if not isTurnedOn then
		if self.windrowerAISound ~= nil then
			setVisibility(self.windrowerAISound, false);
		end;
		if self:getIsActive() then
			if self:getIsActiveForSound() then
				if self.time < self.soundOffset then
					stopSample(self.windrowerStartSound);
				else
					if self.windrowerStopSound ~= nil then
						playSample(self.windrowerStopSound, 1, self.windrowerStopSoundVolume, 0);
						soundOffset = getSampleDuration(self.windrowerStopSound);
					end;
				end;
			end;
		end;
	else
		if self:getAnimationTime("folding") ~= 0 then
			self.unfoldWarningTime = g_currentMission.time+2000;
			self:setIsTurnedOn(false);
		else
			self.isInTransportState = false;
			if self:getIsActive() then
				if self:getIsActiveForSound() then
					self.windrowerSoundEnabled = false;
					stopSample(self.windrowerSound);
					if self.time < self.soundOffset then
						stopSample(self.windrowerStopSound);
					end;
					playSample(self.windrowerStartSound, 1, self.windrowerStartSoundVolume, 0);
					soundOffset = getSampleDuration(self.windrowerStartSound);
				elseif self.attacherVehicle.isControlled then
					if self.windrowerAISound ~= nil then
						setVisibility(self.windrowerAISound, true);
					end;
				end;
			end;
		end;
	end;
	self.soundOffset = self.time + soundOffset;
end;