-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

wheelWeightToggleControlEvent = {};
wheelWeightToggleControlEvent_mt = Class(wheelWeightToggleControlEvent, Event);

InitEventClass(wheelWeightToggleControlEvent, "wheelWeightToggleControlEvent");

function wheelWeightToggleControlEvent:emptyNew()
    local self = Event:new(wheelWeightToggleControlEvent_mt);
    return self;
end;

function wheelWeightToggleControlEvent:new(object, isInControll)
    local self = wheelWeightToggleControlEvent:emptyNew()
    self.object = object;
    self.isInControll = isInControll;
    return self;
end;

function wheelWeightToggleControlEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.isInControll = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function wheelWeightToggleControlEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.isInControll);
end;

function wheelWeightToggleControlEvent:run(connection)
    self.object:toggleControl(self.isInControll, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(wheelWeightToggleControlEvent:new(self.object, self.isInControll), nil, connection, self.object);
    end;
end;
