Annaburger_HTS = {};

function Annaburger_HTS.prerequisitesPresent(specializations)
    return true;
end;

function Annaburger_HTS:load(xmlFile)
	
	local towBall = getXMLString(xmlFile, "vehicle.towBall#file");
	if towBall ~= nil then
		towBall = Utils.getFilename(towBall, self.baseDirectory);
		self.towBall = towBall;
	else
		print("No towBall path available");
	end;	

	self.attacherJointString = getXMLString(xmlFile, "vehicle.towBall#attacherPoint");
	
	self.attacherPoint = nil;
	self.loadedTowBall = nil;
	
	self.vehicleJoint = nil;
	self.jointSearch = false;
	
end;

function Annaburger_HTS:delete()
end;

function Annaburger_HTS:readStream(streamId, connection)	
end;

function Annaburger_HTS:writeStream(streamId, connection)
end;

function Annaburger_HTS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Annaburger_HTS:keyEvent(unicode, sym, modifier, isDown)
end;

function Annaburger_HTS:update(dt)
	
	
	if self.jointSearch then
		for k,v in pairs(self.attacherVehicle.attachedImplements) do
			if v.object == self then
				local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
				self.vehicleJoint = joint;	
				
				-- load,link i3d-File
				local i3dTowBall = loadI3DFile(self.towBall);
				i3dTowBall = getChildAt(i3dTowBall,0);
				if i3dTowBall ~= 0 then
					self.attacherPoint = Utils.indexToObject(i3dTowBall, self.attacherJointString);
					self.loadedTowBall = i3dTowBall;
					link(joint.jointTransform, i3dTowBall);
				end;
				
				setJointFrame(joint.jointIndex, 0, self.attacherPoint);
			end;
		end;
		self.jointSearch = false;
	end;
	
end;

function Annaburger_HTS:updateTick(dt)
	
end;

function Annaburger_HTS:draw()

end;

function Annaburger_HTS:onAttach(attacherVehicle)
	self.jointSearch = true;
end;

function Annaburger_HTS:onDetach()

	if self.loadedTowBall ~= nil then
		
		unlink(self.loadedTowBall);
		delete(self.loadedTowBall);
		self.attacherPoint = nil;
		self.loadedTowBall = nil;
	end;
	self.vehicleJoint = nil;
end;