rails = {};

function rails.prerequisitesPresent(specializations)
    return true;
end;

function rails:load(xmlFile)
	self.setChangeVisibility = SpecializationUtil.callSpecializationsFunction("setChangeVisibility");

	self.rails = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.Straps#rails"));

	setVisibility(self.rails, false);

	self.railMode = 0;
	self.railActive = false;
end;

function rails:delete()
end;

function rails:readStream(streamId, connection)
	self:setChangeVisibility(streamReadInt8(streamId), true);

end;

function straps:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.strap);

end;


function straps:mouseEvent(posX, posY, isDown, isUp, button)
end;

function straps:keyEvent(unicode, sym, modifier, isDown)
end;

function rails:update(dt)
	-- Key management --
	if self.inrange then
		-- Display help text --
		g_currentMission:addHelpButtonText(g_i18n:getText("RAILS"), InputBinding.RAILS);
		if InputBinding.hasEvent(InputBinding.RAILS) then
			if self.railMode > 1 then
				self.railMode = 0;
			end;
			self:setChangeVisibility(math.abs(self.railMode + 1));
		end;
	end;
end;

function straps:updateTick(dt)
	if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.inrange = true;
		else
			self.inrange = false;
		end;
	end;
end;

function rails:draw()


end;

function rails:setChangeVisibility(rails, noEventSend)
	self.railMode = rails;

	if self.railMode == 0 then
		self.railActive = false;
	end;
	if self.railMode == 1 then
		self.railActive = true;
	end;
	if self.railMode == 2 then
		self.railActive = false;
	end;

	if self.railMode > 2 then
		self.railMode = 0;
	end;

	setVisibility(self.rails, self.rail);

end;

ChangeVisibilityEvent = {};
ChangeVisibilityEvent_mt = Class(ChangeVisibilityEvent, Event);

InitEventClass(ChangeVisibilityEvent, "ChangeVisibilityEvent");

function ChangeVisibilityEvent:emptyNew()
    local self = Event:new(ChangeVisibilityEvent_mt);
    self.className="ChangeVisibilityEvent";
    return self;
end;

function ChangeVisibilityEvent:new(vehicle, rails)
    local self = ChangeVisibilityEvent:emptyNew()
    self.vehicle = vehicle;
	self.rails = rails;
    return self;
end;

function ChangeVisibilityEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.rails = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeVisibilityEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.rails);
end;

function ChangeVisibilityEvent:run(connection)
	self.vehicle:setChangeVisibility(self.rails, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChangeVisibilityEvent:new(self.vehicle, self.rails), nil, connection, self.vehicle);
	end;
end;

function ChangeVisibilityEvent.sendEvent(vehicle, rails, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeVisibilityEvent:new(vehicle, rails), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeVisibilityEvent:new(vehicle, rails));
		end;
	end;
end;
