--
-- v1   LS-UK Modteam
-- 
-- v1.1 SAR-michael
--

straps = {};

function straps.prerequisitesPresent(specializations)
    return true;
end;

function straps:load(xmlFile)
	self.setChangeVisibility = SpecializationUtil.callSpecializationsFunction("setChangeVisibility");

	self.strap = {};
	self.strap[1] = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.Straps#index1"));
	self.strap[2] = Utils.indexToObject(self.components,getXMLString(xmlFile, "vehicle.Straps#index2"));

	setVisibility(self.strap[1], false);
	setVisibility(self.strap[2], false);

	self.strapMode = 0;
	self.strapActive = false;
	self.rbStrapActive = false;
end;

function straps:delete()
end;

function straps:readStream(streamId, connection)
	self:setChangeVisibility(streamReadInt8(streamId), true);

end;

function straps:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.strap);

end;


function straps:mouseEvent(posX, posY, isDown, isUp, button)
end;

function straps:keyEvent(unicode, sym, modifier, isDown)
end;

function straps:update(dt)
	-- Key management --
	if self.inrange then
		-- Display help text --
		g_currentMission:addHelpButtonText(g_i18n:getText("STRAPS"), InputBinding.STRAPS);
		if InputBinding.hasEvent(InputBinding.STRAPS) then
			if self.strapMode > 2 then
				self.strapMode = 0;
			end;
			self:setChangeVisibility(math.abs(self.strapMode + 1));
		end;
	end;
end;

function straps:updateTick(dt)
	if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode);
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.inrange = true;
		else
			self.inrange = false;
		end;
	end;
end;

function straps:draw()


end;

function straps:setChangeVisibility(straps, noEventSend)
ChangeVisibilityEvent.sendEvent(self, straps, noEventSend);
	self.strapMode = straps;

	if self.strapMode == 0 then
		self.strapActive = false;
		self.rbStrapActive = false;
	end;
	if self.strapMode == 1 then
		self.strapActive = true;
		self.rbStrapActive = false;
	end;
	if self.strapMode == 2 then
		self.strapActive = false;
		self.rbStrapActive = true;
	end;
	if self.strapMode == 3 then
		self.strapActive = false;
		self.rbStrapActive = false;
	end;

	if self.strapMode > 2 then
		self.strapMode = 0;
	end;

	setVisibility(self.strap[1], self.strapActive);
	setVisibility(self.strap[2], self.rbStrapActive);

end;

ChangeVisibilityEvent = {};
ChangeVisibilityEvent_mt = Class(ChangeVisibilityEvent, Event);

InitEventClass(ChangeVisibilityEvent, "ChangeVisibilityEvent");

function ChangeVisibilityEvent:emptyNew()
    local self = Event:new(ChangeVisibilityEvent_mt);
    self.className="ChangeVisibilityEvent";
    return self;
end;

function ChangeVisibilityEvent:new(vehicle, straps)
    local self = ChangeVisibilityEvent:emptyNew()
    self.vehicle = vehicle;
	self.strap = straps;
    return self;
end;

function ChangeVisibilityEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.strap = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeVisibilityEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.strap);
end;

function ChangeVisibilityEvent:run(connection)
	self.vehicle:setChangeVisibility(self.strap, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(ChangeVisibilityEvent:new(self.vehicle, self.strap), nil, connection, self.vehicle);
	end;
end;

function ChangeVisibilityEvent.sendEvent(vehicle, straps, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeVisibilityEvent:new(vehicle, straps), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeVisibilityEvent:new(vehicle, straps));
		end;
	end;
end;
