--
-- 
-- 
--
-- @author Boembchen big thanks to Sven77b 
-- @date  09/04/09
--
-- Copyright (C) by Boembchen

Fendt614LsaFL = {};

function Fendt614LsaFL.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fendt614LsaFL:load(xmlFile)

    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    

    self.mirrors = {};
    self.mirrors[1] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrors.mirror1#index"));
    self.mirrors[2] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mirrors.mirror2#index"));

    self.showhelp = false;
    self.hudInfo = Utils.getFilename("hud_help_base.png", self.baseDirectory);
    self.hudInfoPoxX = 0.012;
    self.hudInfoPoxY = 0.1825;
    self.hudInfoWidth = 0.425;
    self.hudInfoHeight = 0.1625;
    self.hudInfoOverlay = Overlay:new("hudInfoOverlay", self.hudInfo, self.hudInfoPoxX, self.hudInfoPoxY, self.hudInfoWidth, self.hudInfoHeight);

    self.drawMirror = getVisibility(self.mirrors[1])
    self.revLimit = 100;
    self.maxRpm3 = self.motor.maxRpm[3];
    self.activeTAJ = 0;

end;

function Fendt614LsaFL:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == self.keys.rundumleuchte then
      self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    
    if isDown and sym == self.keys.spiegel then
    	self.drawMirror = not self.drawMirror;
    	setVisibility(self.mirrors[1], self.drawMirror);
    	setVisibility(self.mirrors[2], self.drawMirror);
    end;
    
    if isDown and sym == self.keys.hilfe then
      if self.hudInfoOverlay ~= nil then
      	self.showhelp = not self.showhelp;
      end;
    end;

end;


function Fendt614LsaFL:update(dt)
    if self.isEntered then

        if Input.isKeyPressed(self.keys.rev_up) and self.revLimit < 100 then
          self.revLimit = self.revLimit + 1;
        elseif Input.isKeyPressed(self.keys.rev_down) and self.revLimit > 10 then
          self.revLimit = self.revLimit - 1;
        end;
        self.motor.maxRpm[3] = string.format("%d",(self.revLimit * self.maxRpm3 / 100));

      

        if self.rundumleuchtenAn then
          for i=1, self.rundumleuchtenAnz do
            rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
          end;
        end;



end;

end;

function Fendt614LsaFL:draw()

    g_currentMission:addExtraPrintText("Drehzahlbegrenzer: "..string.format("%d Prozent",self.revLimit));
    if not self.showhelp then
    	g_currentMission:addExtraPrintText("Taste "..string.upper(string.char(self.keys.hilfe))..": Hilfebox einblenden");
    else
    	self.hudInfoOverlay:render();
    	local helptext={};
    	helptext[1] = "Taste "..key_convert(self.keys.rundumleuchte)..": Rundumleuchte";
    	helptext[2] = "Taste "..key_convert(self.keys.spiegel)..": Spiegel";
    	helptext[3] = "Tasten "..key_convert(self.keys.rev_up).."|"..key_convert(self.keys.rev_down)..": Drehzahlbegrenzer heben/senken";
    	helptext[4] = "Taste "..key_convert(self.keys.hilfe)..": Hilfebox ausblenden";
    	if self.rundumleuchtenAn then
    		 helptext[1] = helptext[1].." (an)";
    	else
    		 helptext[1] = helptext[1].." (aus)";
    	end;
    	if self.drawMirror then
    		 helptext[2] = helptext[2].." (an)";
    	else
    		 helptext[2] = helptext[2].." (aus)";
    	end;
    	for i=1, table.getn(helptext) do
    		renderText((self.hudInfoPoxX+0.05),((self.hudInfoPoxY+self.hudInfoHeight) - (0.02*i)),0.02,helptext[i]);
    	end;
    end;

end;

function Fendt614LsaFL:onEnter()
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function Fendt614LsaFL:onLeave()
    self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
    Utils.setEmittingState(self.exhaustParticleLow, false);
end;

function Fendt614LsaFL:delete()
end;


function Fendt614LsaFL:mouseEvent(posX, posY, isDown, isUp, button)
end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;



