--
-- Worklights
-- Specialization for seperate worklights
--
-- @author Templaer
-- @date  06/12/09
--

Worklights = {};

function Worklights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Worklights:load(xmlFile)
	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.worklights.worklight%d", i);
        self.worklights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;
	self.worklightsActive = false;
end;

function Worklights:delete()
end;

function Worklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Worklights:keyEvent(unicode, sym, modifier, isDown)
end;

function Worklights:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.MYWORKLIGHTS) then
			self.worklightsActive = not self.worklightsActive;
			for k, worklight in pairs(self.worklights) do
				setVisibility(worklight, self.worklightsActive);
			end;
		end;
	end;
end;

function Worklights:onLeave()
	for k, worklight in pairs(self.worklights) do
		setVisibility(worklight, false);
	end;
	self.worklightsActive = false;
end;

function Worklights:draw()
	self:addInfoText(InputBinding.MYWORKLIGHTS, g_i18n:getText("Worklights"));
end;

