twinwheels = {};

function twinwheels.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function twinwheels:load(xmlFile)

	
	self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);
    end;

     self.twinWheelsActive= false;

end;

function twinwheels:delete()
end;

function twinwheels:mouseEvent(posX, posY, isDown, isUp, button)
end;


function twinwheels:keyEvent(unicode, sym, modifier, isDown)

if isDown and sym == Input.KEY_1 then 
		self.twinWheelsActive = not self.twinWheelsActive;
	end;

end;

function twinwheels:update(dt)

	
	if self.twinWheelsActive then
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive);
		end;
	else
		for i=1, self.numTwinWheels do
			local twinWheel = self.twinWheels[i];
			setVisibility(twinWheel, self.twinWheelsActive, false);
		end;
	end;


end;

function twinwheels:onLeave()


end;


function twinwheels:draw()

		if self.twinWheelsActive then	
			g_currentMission:addExtraPrintText("Twin Wheels Off: Key 1");
		else
			g_currentMission:addExtraPrintText("Twin Wheels On: Key 1");
		end;

end;

