--
-- versaTrans
-- This specialization can simulate any transmission that uses some form of powershift
--
-- @author  Templaer
-- @date  31/08/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

versaTrans = {};

function versaTrans.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function versaTrans:load(xmlFile)
    -- Registers the custom functions
	self.resetTimers = SpecializationUtil.callSpecializationsFunction("resetTimers");
	self.shiftMode = SpecializationUtil.callSpecializationsFunction("shiftMode");
	self.doRangeShift = SpecializationUtil.callSpecializationsFunction("doRangeShift");
	self.doPowershift = SpecializationUtil.callSpecializationsFunction("doPowershift");
	self.resetStartingGear = SpecializationUtil.callSpecializationsFunction("resetStartingGear");
	
    self.origMaxRpm = self.motor.maxRpm[3];
		
	self.fullPowershift = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.fullPowershift"), false);
	self.hasHexashift = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hasHexashift"), false);
	self.hasAutoMode = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.hasAutoMode"), true);
	self.numRanges = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.numRanges#count"), 4);
	self.numLevels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.numLevels#count"), 6);
	self.startingRange = math.min(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.startingRange#number"), 3), self.numRanges) - 1;
	self.startingLevel = math.min(Utils.getNoNil(getXMLInt(xmlFile, "vehicle.startingLevel#number"), 1), self.numLevels);
	
	self.currentMode = 1;
	self.modes = {"Manual", "Auto", "HexActiv"};
	self.automaticTimer = 0;
	self.automaticReverseTimer = 0;
	self.powershiftLevel = 1;
    self.currentRange = 0;
end;

function versaTrans:delete()
end;

function versaTrans:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local currentMode =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#currentMode"), 1);
    self.currentMode = currentMode;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function versaTrans:getSaveAttributesAndNodes(nodeIdent)
    local currentMode = Utils.getNoNil(self.currentMode, 1);
    local attributes = 'currentMode="'..string.format("%d", currentMode)..'"';
    return attributes, nil;
end;

function versaTrans:mouseEvent(posX, posY, isDown, isUp, button)
end;

function versaTrans:keyEvent(unicode, sym, modifier, isDown)
end;

function versaTrans:update(dt)
    if self.isMotorStarted and self:getIsActiveForInput() and self.isEntered then
	
	    self.motor.speedLevel = 1;
						
		if not self.fullPowershift then		
		    local currentRpm = (self.currentRange * (self.origMaxRpm / self.numRanges) + self.powershiftLevel * self.origMaxRpm / self.numRanges / self.numLevels)
			if self.currentRange < self.numRanges - 1 then	
				self.motor.maxRpm[1] = currentRpm * 0.75;
			else
				self.motor.maxRpm[1] = currentRpm * (0.65 + (0.35 / self.numLevels * self.powershiftLevel));
			end;
			
			if InputBinding.hasEvent(InputBinding.RANGEUP) then
				self:doRangeShift("up");
			end;
			if InputBinding.hasEvent(InputBinding.RANGEDOWN) then
				self:doRangeShift("down");
			end;
		else
			self.hasHexashift = false;
			self.motor.maxRpm[3] = (self.origMaxRpm / self.numLevels) * self.powershiftLevel;
		end;
			
		if self.cruiseControl then
		    self.input = 1;
		end;
			
		-- Handle level input
		if InputBinding.hasEvent(InputBinding.LEVELUP) then
			self:doPowershift("up");
		end;
		if InputBinding.hasEvent(InputBinding.LEVELDOWN) then
			self:doPowershift("down");
		end;
		
		if self.hasAutoMode then
			if InputBinding.hasEvent(InputBinding.AUTOMATIC) then
				self:shiftMode();
			end;
			
			-- Automatically control the HexashiftLevel
			if self.currentMode > 1 then
				if math.abs(self.input) > 0 or self.cruiseControl then
					self.automaticTimer = self.automaticTimer + (dt / 1000);
				else 
					self:resetTimers(false);
				end;
				self.automaticReverseTimer = self.automaticReverseTimer + (dt / 1000);
			
				if math.abs(self.input) > 0.8 and self.automaticTimer >= 1.5 then
					if self.currentMode == 3 and self.powershiftLevel == self.numLevels then
						self:doRangeShift("up");
					else
						self:doPowershift("up");
					end;
				elseif math.abs(self.input) < 0.5 and self.automaticReverseTimer >= 1 then
					if self.currentMode == 3 and self.powershiftLevel == 1 then
					    if self.currentRange > self.startingRange or self.currentRange < self.startingRange then
							self:doRangeShift("down");
						end;
					elseif self.fullPowershift then
						if self.powershiftLevel > self.startingLevel or self.powershiftLevel < self.startingLevel then
							self:doPowershift("down");			
						end;		
					else
						self:doPowershift("down");		
					end;
				end;			
			end;
		end;
	end;
end;

function versaTrans:resetTimers(both) -- Function to reset the timers
    self.automaticTimer = 0;
	if both then
	    self.automaticReverseTimer = 0;
	end;
end;

function versaTrans:shiftMode()
	if self.hasAutoMode and self.hasHexashift and self.currentMode < 3 then
		self.currentMode = self.currentMode + 1;
	elseif self.hasAutoMode and self.currentMode < 2 then
		self.currentMode = self.currentMode + 1;
	else
		self.currentMode = 1;
	end;
	self:resetTimers(true);
end;

function versaTrans:doRangeShift(direction) -- Function to shift ranges
	if direction == "up" and self.currentRange < self.numRanges - 1 then
	    self.currentRange = self.currentRange + 1;
		self.powershiftLevel = 1;
		self.motor.minRpm = 100;
	elseif direction == "down" and self.currentRange > 0 then
	    self.currentRange = self.currentRange - 1;
		self.powershiftLevel = self.numLevels;
		self.motor.minRpm = -400;
	end;
	self:resetTimers(true);
end;

function versaTrans:doPowershift(direction) -- Function to shift powershift steps
    if direction == "up" and self.powershiftLevel < self.numLevels then
		self.powershiftLevel = self.powershiftLevel + 1;
		self.motor.minRpm = 100;
	elseif direction == "down" and self.powershiftLevel > 1 then
		self.powershiftLevel = self.powershiftLevel - 1;
		self.motor.minRpm = -300;
	end;
	self:resetTimers(true);
end;

function versaTrans:resetStartingGear()
	if not self.isAITractorActivated then
		self.powershiftLevel = self.startingLevel;
		self.currentRange = self.startingRange;
	end;
end;

function versaTrans:draw()
end;

