--
-- Quadrant3400 for CLAAS MOD, by Ls-ModSource.com
-- Class for all Quadrant3400s
--
-- @author  Felix "Outlaw" S. and Geri-G
-- @date  28/03/09
-- @date  26/01/010
--
-- Copyright (C) Outlaw/Geri-G, Confidential, All Rights Reserved.

Quadrant3400 = {};

function Quadrant3400.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Quadrant3400:load(xmlFile)

	local count = getXMLInt(xmlFile, "vehicle.drums#count");
    self.drums = {}
	local part = self.drums;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.drums.part" .. "%d", i);
	    part[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, partname .. "#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#rot"));
		part[i].rot = {};
	    part[i].rot[1] = Utils.getNoNil(x, 0);
	    part[i].rot[2] = Utils.getNoNil(y, 0);
	    part[i].rot[3] = Utils.getNoNil(z, 0);
		for j=1, 3 do
			if part[i].rot[j] ~= 0 then
				part[i].rot[j] = 1/part[i].rot[j]
			end;
		end;
    end;
	

    self.getTimeFromLevel = Quadrant3400.getTimeFromLevel;
    self.moveBales = SpecializationUtil.callSpecializationsFunction("moveBales");
    self.moveBale = SpecializationUtil.callSpecializationsFunction("moveBale");
    self.allowFillType = Quadrant3400.allowFillType;
    self.fillScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillScale#value"), 1);

    local firstBaleMarker = getXMLFloat(xmlFile, "vehicle.baleAnimation#firstBaleMarker");
    if firstBaleMarker ~= nil then
        local baleAnimCurve = AnimCurve:new(linearInterpolatorN);
        local keyI = 0;
        while true do
            local key = string.format("vehicle.baleAnimation.key(%d)", keyI);
            local t = getXMLFloat(xmlFile, key.."#time");
            local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#pos"));
            if x == nil or y == nil or z == nil then
                break;
            end;
            local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key.."#rot"));
            rx = math.rad(Utils.getNoNil(rx, 0));
            ry = math.rad(Utils.getNoNil(ry, 0));
            rz = math.rad(Utils.getNoNil(rz, 0));
            baleAnimCurve:addKeyframe({ v={x, y, z, rx, ry, rz}, time = t});
            keyI = keyI +1;
        end;
        if keyI > 0 then
            self.baleAnimCurve = baleAnimCurve;
            self.baleAnimRoot = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleAnimation#node")), self.components[1].node);
            self.firstBaleMarker = firstBaleMarker;
            self.baleTypes = {};
            local i = 0;
            while true do
                local key = string.format("vehicle.baleTypes.baleType(%d)", i);
                local t = getXMLString(xmlFile, key.."#fruitType");
                local filename = getXMLString(xmlFile, key.."#filename");
                local OrginalBalles = Utils.getNoNil(getXMLBool(xmlFile, key.."#OrginalBalles"), true);
                if t==nil or filename==nil then
                    break;
                end;

                local entry = {};
                entry.filename = filename;
                local desc = FruitUtil.fruitTypes[t];
                if desc ~= nil then
                    self.baleTypes[desc.index] = entry;

                    if self.defaultBaleType == nil then
                        self.defaultBaleType = entry;
                    end;
                end;
                i = i +1;
            end;
            if self.defaultBaleType == nil then
                self.baleTypes = nil;
            end;
        end;
    end;

    local balerSound = getXMLString(xmlFile, "vehicle.balerSound#file");
    if balerSound ~= nil and balerSound ~= "" then
        balerSound = Utils.getFilename(balerSound, self.baseDirectory); 
        self.balerSound = createSample("balerSound");
        self.balerSoundEnabled = false;
        loadSample(self.balerSound, balerSound, false);
        self.balerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerSound#pitchOffset"), 1);
        self.balerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.balerSound#volume"), 1);
    end;
	
	local airSound = getXMLString(xmlFile, "vehicle.airSound#file");
    if airSound ~= nil and airSound ~= "" then
        airSound = Utils.getFilename(airSound, self.baseDirectory); 
        self.airSound = createSample("airSound");
        self.airSoundEnabled = false;
        loadSample(self.airSound, airSound, false);
        self.airSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.airSound#pitchOffset"), 1);
        self.airSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.airSound#volume"), 1);
    end;
	self.pickup = {};
	self.pickup.minRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.pickup#minRotLimit"))};
	self.pickup.maxRot = {Utils.degToRad(getXMLFloat(xmlFile, "vehicle.pickup#maxRotLimit"))};
	self.pickup.rotTime = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pickup#rotTime"),2) * 1000;
	self.pickup.currentRot = {0};
	self.pickup.movingDirection = 0;	
	self.pickup.isDown = false;	
	
    self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)
    end;

	local Quot = 16/9;

	local counterpath = Utils.getFilename("counter.png", self.baseDirectory);
	local counterpath2 = Utils.getFilename("counterWarning.png", self.baseDirectory);
	local counterpath3 = Utils.getFilename("counterfill.png", self.baseDirectory);
	local hudPDAPoxX = 0.0;
    local hudPDAPoxY = 0.0; 
    local hudPDAHeight = 0.420;
    local hudPDAWidth = hudPDAHeight/Quot
	local PosX = 0.1540;
	local PosY = 0.1420;
	self.BHeight = 0.1080;
	local BWidth = 0.0203;

	self.hudBasePoxX = {};
	self.hudBasePoxY = {};
	self.hudBasePoxX[0] = hudPDAPoxX+0.0835;
	self.hudBasePoxY[0] = hudPDAPoxY+0.1800;	
	self.hudBasePoxX[1] = hudPDAPoxX+0.0000;
	self.hudBasePoxY[1] = hudPDAPoxY+0.0845;
	self.hudBasePoxX[1] = hudPDAPoxX+0.0360;
	self.hudBasePoxY[1] = hudPDAPoxY+0.2320;
	self.hudBasePoxX[2] = hudPDAPoxX+0.0360;
	self.hudBasePoxY[2] = hudPDAPoxY+0.2035;
	self.hudBasePoxX[3] = hudPDAPoxX+0.0365;
	self.hudBasePoxY[3] = hudPDAPoxY+0.1730;
	self.hudBasePoxX[4] = hudPDAPoxX+0.0380;
	self.hudBasePoxY[4] = hudPDAPoxY+0.1440;
	self.hudBasePoxX[5] = hudPDAPoxX+0.0395;
	self.hudBasePoxY[5] = hudPDAPoxY+0.1155;
	self.hudBasePoxX[6] = hudPDAPoxX+0.1890;
	self.hudBasePoxY[6] = hudPDAPoxY+0.2315;
	self.hudBasePoxX[7] = hudPDAPoxX+0.1890;
	self.hudBasePoxY[7] = hudPDAPoxY+0.2025;
	self.hudBasePoxX[8] = hudPDAPoxX+0.1890;
	self.hudBasePoxY[8] = hudPDAPoxY+0.1730;
	self.hudBasePoxX[9] = hudPDAPoxX+0.1870;
	self.hudBasePoxY[9] = hudPDAPoxY+0.1440;
	self.hudBasePoxX[10] = hudPDAPoxX+0.1860;
	self.hudBasePoxY[10] = hudPDAPoxY+0.1155;
    self.hudPDAOverlay = Overlay:new("hudPDAControl", counterpath, hudPDAPoxX, hudPDAPoxY, hudPDAWidth, hudPDAHeight);
    self.hudPDAOverlayL = Overlay:new("hudPDAControl2", counterpath2, hudPDAPoxX, hudPDAPoxY, hudPDAWidth, hudPDAHeight);
    self.hudPDAOverlayB = Overlay:new("hudPDAControl3", counterpath3, PosX, PosY, BWidth, self.BHeight);

	
    self.baleMoveLastTime = 0;
	self.counter = 0; 
    self.bales = {};
    self.wasToFast = false;
    self.isTurnedOn = false;
	self.hudActive = true;
	self.checkA = 0;
	self.airC = 0; 
	self.runPickup = false;	
	self.Speed.trsp = 10.0; 
	self.Go.trsp = not self.Go.trsp;
	self.Done.trsp = true;
end;




function Quadrant3400:keyEvent(unicode, sym, modifier, isDown)

end;


function Quadrant3400:update(dt)
	self.Speed.pillar = 1.0;
	if self.Go.pillar ~= nil and self.Done.pillar ~= false then
		self:anim("pillar", false); 
		local joint = self.componentJoints[3];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);	
	end;
	if self.Go.trsp ~= nil and self.Done.trsp ~= false then
		self:anim("trsp", false); 
		local joint = self.componentJoints[2];
		setJointFrame(joint.jointIndex, 0,joint.jointNode);
	end;
    self.wasToFast = false;
	
	if self:getIsActive() then
		if InputBinding.hasEvent(InputBinding.QuadrantTRSP)  and not self.pickup.isDown and not self.isTurnedOn then				
			self.Speed.trsp = 1.0; 
			self.Go.trsp = not self.Go.trsp;
			if not self.Go.trsp then
				self.Done.trsp = true; 
			end;
		end;
	
		if self.Go.trsp and not self.CheckDone.trsp then
			if table.getn(self.bales) > 2  then	
				for i = 1, table.getn(self.bales)-2 do
					self:moveBale(i,self:getTimeFromLevel(20));
				end;
			elseif table.getn(self.bales) <= 2 then
				self.Done.trsp = true; 
			end;
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and self.Go.trsp == false and self.CheckDone.trsp == false then
			self.isTurnedOn = not self.isTurnedOn;
			self.runPickup = not self.runPickup;
		end;
		if InputBinding.hasEvent(InputBinding.QuadrantReset) then
			self.counter = 0;
		end;		
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) and self.Go.trsp == false and self.CheckDone.trsp == false then	
			self.pickup.isDown = not self.pickup.isDown;
		end;		
		if InputBinding.hasEvent(InputBinding.QuadrantOverlay) then	
			self.hudActive = not self.hudActive; 
		end;

		if self.runPickup == true then
			for i=1, table.getn(self.drums) do
				rotate(self.drums[i].index, self.drums[i].rot[1]  * dt, self.drums[i].rot[2]  * dt, self.drums[i].rot[3]  * dt);
			end;
		end; 		
		
		local newRotLimit = Utils.getMovedLimitedValues(self.pickup.currentRot, self.pickup.maxRot, self.pickup.minRot, 1, self.pickup.rotTime, dt, not self.pickup.isDown);
		if math.abs(newRotLimit[1] - self.pickup.currentRot[1]) > 0.001 then	
			setJointRotationLimit(self.componentJoints[1].jointIndex, 0, true, 0, newRotLimit[1]);		
		end;		
		self.pickup.currentRot = newRotLimit;				
			
        if self.isTurnedOn and self:allowFillType(FruitUtil.FRUITTYPE_WHEAT) then
            local toFast = self.lastSpeed*3600 > 29;
            if not toFast then
                local totalArea =0;
                local usedFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
                for k, cuttingArea in pairs(self.cuttingAreas) do
                    local x,y,z = getWorldTranslation(cuttingArea.start);
                    local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                    local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                    for fruitType,v in pairs(self.fillTypes) do
                        if fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
                            local area = Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            area = area + Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area > 0 then
                                totalArea = totalArea+area;
                                usedFruitType = fruitType;
                            end;
                        end;
                    end;
                end;
				if totalArea == 0 then
					self.checkA = self.checkA + 1;
					if self.checkA >= 500 then
						Utils.setEmittingState(self.dustParticleSystems, false)
						self.checkA = 0; 
					end; 	
				end; 	
                if totalArea > 0 then
                    local literPerPixel = 4*8000/1200 / 6 / (2*2) *12/4;
                    local deltaLevel = totalArea * literPerPixel * self.fillScale;
                    local deltaTime = self:getTimeFromLevel(deltaLevel);
                    self:moveBales(deltaTime);
                    local oldFillLevel = self.fillLevel;
					self:setFillLevel(self.fillLevel+deltaLevel, usedFruitType);
					Utils.setEmittingState(self.dustParticleSystems, true)
                    if self.fillLevel == self.capacity then
						self.counter = self.counter + 1; 
						self.airC = self.airC +1;
						if self.airC == 5 then
							self.airC = 0; 
							playSample(self.airSound, 1, self.airSoundVolume, 0);
						end; 	
                        local restDeltaFillLevel = deltaLevel - (self.fillLevel-oldFillLevel)
                        self:setFillLevel(restDeltaFillLevel, usedFruitType);
                        if self.baleAnimCurve ~= nil and self.baleTypes ~= nil then
                            local baleType = self.baleTypes[usedFruitType];
                            if baleType == nil then
                                baleType = self.defaultBaleType;
                            end;
                            local baleroot;
								 baleroot = Utils.loadSharedI3DFile(baleType.filename, getAppBasePath());
                            local baleId = getChildAt(baleroot, 0);
                            setRigidBodyType(baleId, "None");
                            link(self.baleAnimRoot, baleId);
                            delete(baleroot);
                            local bale = {};
                            bale.id = baleId;
                            bale.time = 0;
                            bale.filename = baleType.filename;
                            table.insert(self.bales, bale);
                            self:moveBale(table.getn(self.bales), self:getTimeFromLevel(restDeltaFillLevel));
                        end;
                    end;
                end;
				
            end;
            self.wasToFast = toFast;
			if not self.balerSoundEnabled and self:getIsActiveForSound() then
				setSamplePitch(self.balerSound, self.balerSoundPitchOffset);
				playSample(self.balerSound, 0, self.balerSoundVolume, 0);
				self.balerSoundEnabled = true;
			end; 
			
			local FL = self.fillLevel;
			local Cap = self.capacity;
			local percent = (FL*100)/Cap;	
			local Height = (percent* self.BHeight)/100;
			self.hudPDAOverlayB.height = Height;			
	   end;
		if not self.isTurnedOn and self.balerSoundEnabled then
			stopSample(self.balerSound);
			Utils.setEmittingState(self.dustParticleSystems, false)
			self.checkA = 0; 
			self.balerSoundEnabled = false;
		end;
	end;			
end;

function Quadrant3400:draw() 
---Utils.RenderDevolpmentState("Quadrant3400",1)
	if self.hudActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("Quadrant3400_8"), InputBinding.QuadrantOverlay);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("Quadrant3400_7"), InputBinding.QuadrantOverlay);
	end; 
	if self.hudActive == true then
		self.hudPDAOverlay:render();
		setTextBold(false);
		setTextColor(0, 0, 0, 1.0);
		local x = self.hudBasePoxX[0];
		local strg = "000%d";
		if self.counter >= 10 and self.counter < 100 then
			--x = x- 0.015;
			strg = "00%d";
		elseif self.counter >= 100 and self.counter <1000 then
			--x = x- 0.030;
			strg = "0%d";
		elseif self.counter >= 1000 and self.counter <10000 then
			--x = x- 0.045;
			strg = "%d";
		end;
		if not self.wasToFast then
			renderText(x, self.hudBasePoxY[0], 0.040, string.format(strg,self.counter));
		end;
		setTextBold(true);
		setTextColor(1, 1, 1, 1.0);
		renderText(self.hudBasePoxX[1], self.hudBasePoxY[1], 0.020, string.format("%s",tostring(InputBinding.getButtonKeyName(InputBinding.QuadrantTRSP))));
		renderText(self.hudBasePoxX[2], self.hudBasePoxY[2], 0.020, string.format("%s",tostring(InputBinding.getButtonKeyName(InputBinding.IMPLEMENT_EXTRA))));
		renderText(self.hudBasePoxX[3], self.hudBasePoxY[3], 0.020, string.format("%s",tostring(InputBinding.getButtonKeyName(InputBinding.LOWER_IMPLEMENT))));
		renderText(self.hudBasePoxX[4], self.hudBasePoxY[4], 0.020, string.format("%s",tostring(InputBinding.getButtonKeyName(InputBinding.QuadrantReset))));
	end; 

    if self.isTurnedOn then		
		self.hudPDAOverlayB:render();
    end;   
	if self.wasToFast then		
		self.hudPDAOverlayL:render();
    end;	
end;

function Quadrant3400:onAttach()
	self.Speed.pillar = 1.0; 
	self.Go.pillar = true;
	self.Done.pillar = true; 
end; 




function Quadrant3400:onDetach()
    if self.deactivateOnDetach then
        Quadrant3400.onDeactivate(self);
    end;
	self.Speed.pillar = 1.0; 
	self.Go.pillar = false;
	self.Done.pillar = true; 
end;

function Quadrant3400:onLeave()
    if self.deactivateOnLeave then
        Quadrant3400.onDeactivate(self);
    else
        Quadrant3400.onDeactivateSounds(self);
    end;
end;

function Quadrant3400:onDeactivate()

	Utils.setEmittingState(self.dustParticleSystems, false)
    Quadrant3400.onDeactivateSounds(self)
end;

function Quadrant3400:onDeactivateSounds()
	if self.balerSoundEnabled then
        stopSample(self.balerSound);
        self.balerSoundEnabled = false;
    end;
    if self.airSoundEnabled then
        stopSample(self.airSound);
        self.airSoundEnabled = false;
    end;	
end;

function Quadrant3400:getTimeFromLevel(level)
    if self.firstBaleMarker ~= nil then
        return level / self.capacity * self.firstBaleMarker;
    end;
    return 0;
end;


function Quadrant3400:moveBales(dt)
    for i=table.getn(self.bales), 1, -1 do
        self:moveBale(i, dt);
    end;
    self.baleMoveLastTime = self.time
end;


function Quadrant3400:moveBale(i, dt)
    local bale = self.bales[i];
    bale.time = bale.time + dt;
    local v = self.baleAnimCurve:get(bale.time);
    setTranslation(bale.id, v[1], v[2], v[3]);
    setRotation(bale.id, v[4], v[5], v[6]);
    if bale.time >= 1 then
        local deltaRealTime = (self.time - self.baleMoveLastTime)/1000;
        local lx, ly, lz = bale.lastX, bale.lastY, bale.lastZ;
        local x,y,z = getWorldTranslation(bale.id);
        local rx,ry,rz = getWorldRotation(bale.id);
        link(getRootNode(), bale.id);
        g_currentMission:addItemToSave(bale.filename, bale.id);
        setTranslation(bale.id, x, y, z);
        setRotation(bale.id, rx, ry, rz);
        setRigidBodyType(bale.id, "Dynamic");
        setLinearVelocity(bale.id, (x-lx)/deltaRealTime, (y-ly)/deltaRealTime, (z-lz)/deltaRealTime);
        table.remove(self.bales, i);
        if g_currentMission.baleCount ~= nil then
            g_currentMission.baleCount = g_currentMission.baleCount + 1;
        end;
    else
        bale.lastX, bale.lastY, bale.lastZ = getWorldTranslation(bale.id);
    end;
end;

function Quadrant3400:allowFillType(fillType)
    return self.fillTypes[fillType] == true;
end;


function Quadrant3400:delete()
	Utils.deleteParticleSystem(self.dustParticleSystems)
	self.checkA = 0; 
    if self.balerSound ~= nil then
        delete(self.balerSound);
    end;
	if self.airSound ~= nil then
        delete(self.airSound);
    end;
	delete(self.hudPDAOverlay);
	delete(self.hudPDAOverlayL);
end;


function Quadrant3400:mouseEvent(posX, posY, isDown, isUp, button)
end;



