SetArmMiddleDownEvent = {};
SetArmMiddleDownEvent_mt = Class(SetArmMiddleDownEvent, Event);

InitEventClass(SetArmMiddleDownEvent, "SetArmMiddleDownEvent");

function SetArmMiddleDownEvent:emptyNew()
    local self = Event:new(SetArmMiddleDownEvent_mt);
    self.className="SetArmMiddleDownEvent";
    return self;
end;

function SetArmMiddleDownEvent:new(vehicle, isArmMiddleDown)
    local self = SetArmMiddleDownEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmMiddleDown = isArmMiddleDown;
    return self;
end;

function SetArmMiddleDownEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmMiddleDown = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmMiddleDownEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmMiddleDown);
end;

function SetArmMiddleDownEvent:run(connection)   
	self.vehicle:setArmMiddleDown(self.isArmMiddleDown, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmMiddleDownEvent:new(self.vehicle, self.isArmMiddleDown), nil, connection, self.vehicle);
    end;
end;

function SetArmMiddleDownEvent.sendEvent(vehicle, isArmMiddleDown, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmMiddleDownEvent:new(vehicle, isArmMiddleDown), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmMiddleDownEvent:new(vehicle, isArmMiddleDown));
		end;
	end;
end;