SetWrappingEvent = {};
SetWrappingEvent_mt = Class(SetWrappingEvent, Event);

InitEventClass(SetWrappingEvent, "SetWrappingEvent");

function SetWrappingEvent:emptyNew()
    local self = Event:new(SetWrappingEvent_mt);
    self.className="SetWrappingEvent";
    return self;
end;

function SetWrappingEvent:new(vehicle, isWrapping)
    local self = SetWrappingEvent:emptyNew()
    self.vehicle = vehicle;
	self.isWrapping = isWrapping;
    return self;
end;

function SetWrappingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isWrapping = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetWrappingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isWrapping);
end;

function SetWrappingEvent:run(connection)   
	self.vehicle:setWrapping(self.isWrapping, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetWrappingEvent:new(self.vehicle, self.isWrapping), nil, connection, self.vehicle);
    end;
end;

function SetWrappingEvent.sendEvent(vehicle, isWrapping, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetWrappingEvent:new(vehicle, isWrapping), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetWrappingEvent:new(vehicle, isWrapping));
		end;
	end;
end;