---Made By @poc@lypse.

---For ls-modteam-France

Nh = {};

function Nh.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Nh:load(xmlFile)
          print("'lua loaded '" );
   
   
	self.brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.brakeForce"), 10);

    self.controlpath = Utils.getFilename("nhcontrol.png", self.baseDirectory);
    self.hudclaasPoxX = 0.01;
    self.hudclaasPoxY = 1-0.204;
    self.hudclaasWidth = 0.240;
    self.hudclaasHeight = 0.240;
    self.hudclaasPoxX = 0.75;
    self.hudclaasPoxY = 0.60
	self.hudclaasOverlay = Overlay:new("hudNhcontrol", self.controlpath, self.hudclaasPoxX, self.hudclaasPoxY, self.hudclaasWidth, self.hudclaasHeight);


    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;

    self.numtravails = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.travails#count"), 0);
    self.travails = {};
    for i=1, self.numtravails do
        local travailnamei = string.format("vehicle.travails.travail" .. "%d", i);
        self.travails[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, travailnamei .. "#index"));
        setVisibility(self.travails[i], false);
    end;
    
    local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;

     local rotationPartNodeporte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.porte#index"));
    if rotationPartNodeporte ~= nil then
        self.rotationPartporte = {};
        self.rotationPartporte.node = rotationPartNodeporte;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartporte#minRot"));
        self.rotationPartporte.minRot = {};
        self.rotationPartporte.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.porte#maxRot"));
        self.rotationPartporte.maxRot = {};
        self.rotationPartporte.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartporte.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartporte.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartporte.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.porte#rotTime"), 2)*1000;
        self.rotationPartporte.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.porte#touchRotLimit"), 10));
    end;

    self.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    self.twinWheels = {};
    for i=1, self.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        self.twinWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(self.twinWheels[i], false);
    end;
	
	self.numSmallWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.smallWheels#count"), 0);
    self.smallWheels = {};
    for i=1, self.numSmallWheels do
        local smallWheelnamei = string.format("vehicle.smallWheels.smallWheel" .. "%d", i);
        self.smallWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, smallWheelnamei .. "#index"));
        setVisibility(self.smallWheels[i], true);
    end;
    
    self.numBigWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.bigWheels#count"), 0);
    self.bigWheels = {};
    for i=1, self.numBigWheels do
        local bigWheelnamei = string.format("vehicle.bigWheels.bigWheel" .. "%d", i);
        self.bigWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, bigWheelnamei .. "#index"));
        setVisibility(self.bigWheels[i], false);
    end;
    
    self.numjumWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.jumWheels#count"), 0);
    self.jumWheels = {};
    for i=1, self.numjumWheels do
        local jumWheelnamei = string.format("vehicle.jumWheels.jumWheel" .. "%d", i);
        self.jumWheels[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, jumWheelnamei .. "#index"));
        setVisibility(self.jumWheels[i], false);
    end;
    
    self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
     self.motorBrakeForce = self.motor.brakeForce;
	self.brakeOn = false;
    self.revLimit = 100;
    self.maxRpm3 = self.motor.maxRpm[3];
    self.worklightsActive = false;
    self.travailsActive = false;
    self.twinWheelsActive = false;
	self.bigWheelsActive = false;
    self.jumWheelsActive = false;
    self.smallWheelsActive = true;

    
    self.bcActive = false;
    
end;

function Nh:delete()
end;

function Nh:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Nh:keyEvent(unicode, sym, modifier, isDown)
    
    if isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
    end;
    
    if isDown and sym == Input.KEY_9 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end; 

     if isDown and sym == Input.KEY_o then 
		self.rotationMaxporte = not self.rotationMaxporte;
	end; 

    if isDown and sym == Input.KEY_5 then
		self.worklightsActive = not self.worklightsActive;
	end;
     
    if isDown and sym == Input.KEY_4 then
		self.travailsActive = not self.travailsActive;
	end;

    if isDown and sym == Input.KEY_6 then
        self.twinWheelsActive = not self.twinWheelsActive;
		self.bigWheelsActive = false;
        self.jumWheelsActive = false;
        self.smallWheelsActive = not self.smallWheelsActive;
    end;
	
       
	

    if isDown and sym == Input.KEY_8 then
		self.jumWheelsActive = not self.jumWheelsActive;
		self.twinWheelsActive = false;
        self.bigWheelsActive = false;
        self.smallWheelsActive = true;
	end;
   
    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;
end;

 
function Nh:update(dt)
 
  if self.isEntered then
       
        if self.worklightsActive then
		   for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		   end;
	       else
		   for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		   end;
	    end;
              
        if self.travailsActive then
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive);
		   end;
	       else
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive, false);
		end;
	    end;
		
		if self.twinWheelsActive then
			for i=1, self.numTwinWheels do
				local twinWheel = self.twinWheels[i];
				setVisibility(twinWheel, self.twinWheelsActive);
			end;
		else
			for i=1, self.numTwinWheels do
				local twinWheel = self.twinWheels[i];
				setVisibility(twinWheel, self.twinWheelsActive, false);
			end;
		end;
		
		if self.smallWheelsActive then
			for i=1, self.numSmallWheels do
				local smallWheel = self.smallWheels[i];
				setVisibility(smallWheel, self.smallWheelsActive);
			end;
		else
			for i=1, self.numSmallWheels do
				local smallWheel = self.smallWheels[i];
				setVisibility(smallWheel, self.smallWheelsActive, false);
			end;
		end;
       if not self.bigWheelsActive then
			for i=1, self.numBigWheels do
				local bigWheel = self.bigWheels[i];
				setVisibility(bigWheel, self.bigWheelsActive, false);
			end;
		else
			for i=1, self.numBigWheels do
				local bigWheel = self.bigWheels[i];
				setVisibility(bigWheel, self.bigWheelsActive);
			end;
		end;
        if not self.jumWheelsActive then
			for i=1, self.numjumWheels do
				local jumWheel = self.jumWheels[i];
				setVisibility(jumWheel, self.jumWheelsActive, false);
			end;
		else
			for i=1, self.numjumWheels do
				local jumWheel = self.jumWheels[i];
				setVisibility(jumWheel, self.jumWheelsActive);
			end;
		end;
    end;
    if self.rotationPartbackwindow ~= nil then
		local x, y, z = getRotation(self.rotationPartbackwindow.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		setRotation(self.rotationPartbackwindow.node, unpack(newRot));
   end;

  if self.rotationPartporte ~= nil then
		local x, y, z = getRotation(self.rotationPartporte.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartporte.maxRot, self.rotationPartporte.minRot, 3, self.rotationPartporte.rotTime, dt, not self.rotationMaxporte);
		setRotation(self.rotationPartporte.node, unpack(newRot));
   end;

  if self.isEntered then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
  end;
  
 
 
end;

function Nh:onLeave()
     self.brakeOn = true;
    self.rotationMaxbackwindow = false;
    self.rotationMaxporte = false;
    self.worklightsActive = false;
    self.travailsActive = false;
    self.rundumleuchtenAn = false;
     for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    
 
end;
 

function Nh:draw()
  if self.hudclaasOverlay ~= nil then
  if self.bcActive then
    self.hudclaasOverlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Touche 0: Ecran de controle On");
		else
			g_currentMission:addExtraPrintText("Touche 0: Ecran de controle Off");
		end;
  
end;