---Made By @poc@lypse.

---For ls-modteam-France

ares = {};

function ares:new(configFile, positionX, offsetY, positionZ, rotationY, customMt)

    if ares_mt == nil then
       ares_mt = Class(ares, Vehicle);
    end;

    local mt = customMt;
    if mt == nil then
        mt = ares_mt;
    end;
    local instance = Vehicle:new(configFile, positionX, offsetY, positionZ, rotationY, mt);

    local xmlFile = loadXMLFile("TempConfig", configFile);
   
    instance.hudclaasPoxX = 0.01;
    instance.hudclaasPoxY = 1-0.204;
    instance.hudclaasWidth = 0.240;
    instance.hudclaasHeight = 0.240;
    instance.hudclaasPoxX = 0.75;
    instance.hudclaasPoxY = 0.60
    instance.hudclaasOverlay = Overlay:new("hudclaasControl", "data/vehicles/steerable/claas/ares/arescontrol.png", instance.hudclaasPoxX, instance.hudclaasPoxY, instance.hudclaasWidth, instance.hudclaasHeight);
   
    instance.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    instance.worklights = {};
    for i=1, instance.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        instance.worklights[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(instance.worklights[i], false);
    end;

    instance.numtravails = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.travails#count"), 0);
    instance.travails = {};
    for i=1, instance.numtravails do
        local travailnamei = string.format("vehicle.travails.travail" .. "%d", i);
        instance.travails[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, travailnamei .. "#index"));
        setVisibility(instance.travails[i], false);
    end;
    
    local rotationPartNodebackwindow = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        instance.rotationPartbackwindow = {};
        instance.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartbackwindow#minRot"));
        instance.rotationPartbackwindow.minRot = {};
        instance.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        instance.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        instance.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        instance.rotationPartbackwindow.maxRot = {};
        instance.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        instance.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        instance.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        instance.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        instance.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;

     local rotationPartNodeporte = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, "vehicle.porte#index"));
    if rotationPartNodeporte ~= nil then
        instance.rotationPartporte = {};
        instance.rotationPartporte.node = rotationPartNodeporte;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartporte#minRot"));
        instance.rotationPartporte.minRot = {};
        instance.rotationPartporte.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        instance.rotationPartporte.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        instance.rotationPartporte.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.porte#maxRot"));
        instance.rotationPartporte.maxRot = {};
        instance.rotationPartporte.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        instance.rotationPartporte.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        instance.rotationPartporte.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        instance.rotationPartporte.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.porte#rotTime"), 2)*1000;
        instance.rotationPartporte.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.porte#touchRotLimit"), 10));
    end;

    instance.numTwinWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.twinWheels#count"), 0);
    instance.twinWheels = {};
    for i=1, instance.numTwinWheels do
        local twinWheelnamei = string.format("vehicle.twinWheels.twinWheel" .. "%d", i);
        instance.twinWheels[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, twinWheelnamei .. "#index"));
        setVisibility(instance.twinWheels[i], false);
    end;
	
	instance.numSmallWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.smallWheels#count"), 0);
    instance.smallWheels = {};
    for i=1, instance.numSmallWheels do
        local smallWheelnamei = string.format("vehicle.smallWheels.smallWheel" .. "%d", i);
        instance.smallWheels[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, smallWheelnamei .. "#index"));
        setVisibility(instance.smallWheels[i], false);
    end;
    
    instance.numBigWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.bigWheels#count"), 0);
    instance.bigWheels = {};
    for i=1, instance.numBigWheels do
        local bigWheelnamei = string.format("vehicle.bigWheels.bigWheel" .. "%d", i);
        instance.bigWheels[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, bigWheelnamei .. "#index"));
        setVisibility(instance.bigWheels[i], true);
    end;
    
    instance.numjumWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.jumWheels#count"), 0);
    instance.jumWheels = {};
    for i=1, instance.numjumWheels do
        local jumWheelnamei = string.format("vehicle.jumWheels.jumWheel" .. "%d", i);
        instance.jumWheels[i] = Utils.indexToObject(instance.rootNode, getXMLInt(xmlFile, jumWheelnamei .. "#index"));
        setVisibility(instance.jumWheels[i], true);
    end;
    
    instance.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    instance.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    instance.rundumleuchtenAn = false;
    instance.rundumleuchten = {};
    for i=1, instance.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        instance.rundumleuchten[i] = {};
        instance.rundumleuchten[i].rotNode = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        instance.rundumleuchten[i].light = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, objname .. "#light"));
        instance.rundumleuchten[i].source = Utils.indexToObject(instance.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        instance.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        instance.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not instance.rundumleuchten[i].emit and instance.rundumleuchten[i].source ~= nil then
           setVisibility(instance.rundumleuchten[i].source, false);
        end;
    end;

    instance.worklightsActive = false;
    instance.travailsActive = false;
    instance.twinWheelsActive = false;
	instance.bigWheelsActive = false;
    instance.jumWheelsActive = false;
    instance.smallWheelsActive = true;

    delete(xmlFile);
    instance.bcActive = false;
	if self.hudclaasOverlay ~= nil then
  	self.hudclaasOverlay:delete();
 end;

    return instance;
end;

function ares:keyEvent(unicode, sym, modifier, isDown)
    ares:superClass().keyEvent(self, unicode, sym, modifier, isDown);
    
    if isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
    end;
    
    if isDown and sym == Input.KEY_9 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end; 

     if isDown and sym == Input.KEY_p then 
		self.rotationMaxporte = not self.rotationMaxporte;
	end; 

    if isDown and sym == Input.KEY_5 then
		self.worklightsActive = not self.worklightsActive;
	end;
     
    if isDown and sym == Input.KEY_4 then
		self.travailsActive = not self.travailsActive;
	end;

    if isDown and sym == Input.KEY_6 then
        self.twinWheelsActive = not self.twinWheelsActive;
		self.bigWheelsActive = false;
        self.jumWheelsActive = false;
        self.smallWheelsActive = not self.smallWheelsActive;
    end;
	
       
	if isDown and sym == Input.KEY_7 then
		self.bigWheelsActive = not self.bigWheelsActive;
		self.twinWheelsActive = false;
        self.jumWheelsActive = false;
        self.smallWheelsActive = not self.smallWheelsActive;
	end;

    if isDown and sym == Input.KEY_8 then
		self.jumWheelsActive = not self.jumWheelsActive;
		self.twinWheelsActive = false;
        self.bigWheelsActive = false;
        self.smallWheelsActive = true;
	end;
   
    if self.isEntered then
      if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;
    end;
end;

 
function ares:update(dt)
  
   
  if self.isEntered then
       
        if self.worklightsActive then
		   for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive);
		   end;
	       else
		   for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		   end;
	    end;
              
        if self.travailsActive then
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive);
		   end;
	       else
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive, false);
		end;
	    end;
		
		if self.twinWheelsActive then
			for i=1, self.numTwinWheels do
				local twinWheel = self.twinWheels[i];
				setVisibility(twinWheel, self.twinWheelsActive);
			end;
		else
			for i=1, self.numTwinWheels do
				local twinWheel = self.twinWheels[i];
				setVisibility(twinWheel, self.twinWheelsActive, false);
			end;
		end;
		
		if self.smallWheelsActive then
			for i=1, self.numSmallWheels do
				local smallWheel = self.smallWheels[i];
				setVisibility(smallWheel, self.smallWheelsActive);
			end;
		else
			for i=1, self.numSmallWheels do
				local smallWheel = self.smallWheels[i];
				setVisibility(smallWheel, self.smallWheelsActive, false);
			end;
		end;
       if not self.bigWheelsActive then
			for i=1, self.numBigWheels do
				local bigWheel = self.bigWheels[i];
				setVisibility(bigWheel, self.bigWheelsActive, false);
			end;
		else
			for i=1, self.numBigWheels do
				local bigWheel = self.bigWheels[i];
				setVisibility(bigWheel, self.bigWheelsActive);
			end;
		end;
        if not self.jumWheelsActive then
			for i=1, self.numjumWheels do
				local jumWheel = self.jumWheels[i];
				setVisibility(jumWheel, self.jumWheelsActive, false);
			end;
		else
			for i=1, self.numjumWheels do
				local jumWheel = self.jumWheels[i];
				setVisibility(jumWheel, self.jumWheelsActive);
			end;
		end;
    end;
    if self.rotationPartbackwindow ~= nil then
		local x, y, z = getRotation(self.rotationPartbackwindow.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		setRotation(self.rotationPartbackwindow.node, unpack(newRot));
   end;

  if self.rotationPartporte ~= nil then
		local x, y, z = getRotation(self.rotationPartporte.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartporte.maxRot, self.rotationPartporte.minRot, 3, self.rotationPartporte.rotTime, dt, not self.rotationMaxporte);
		setRotation(self.rotationPartporte.node, unpack(newRot));
   end;

  if self.isEntered then
    if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
  end;
  
 
  Vehicle.update(self, dt);
end;

function ares:onLeave()
    self.rotationMaxbackwindow = false;
    self.rotationMaxporte = false;
    self.worklightsActive = false;
    self.travailsActive = false;
    self.rundumleuchtenAn = false;
     for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
     Vehicle.onLeave(self);
 
end;
 

function ares:draw()
  if self.hudclaasOverlay ~= nil then
  if self.bcActive then
    self.hudclaasOverlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Touche 0: Ecran de controle On");
		else
			g_currentMission:addExtraPrintText("Touche 0: Ecran de controle Off");
		end;
  Vehicle.draw(self);
end;