--
-- HasControlPanel
-- Specialization for HasControlPanel functionality
--
-- Modschmiede / LS-Modsource
-- @author  Manuel Leithner
-- @date  27/04/09
--

HasControlPanel = {};

function HasControlPanel.prerequisitesPresent(specializations)
    return true;
end;

function HasControlPanel:load(xmlFile)

	local controlPanel = getXMLString(xmlFile, "vehicle.controlPanel#file");
	if controlPanel ~= nil then
		controlPanel = Utils.getFilename(controlPanel, self.baseDirectory);
		self.controlPanel = controlPanel;
	else
		print("No controlpanel path available");
	end;
	
	self.controlAttacherVehicle = nil;
	
end;

function HasControlPanel:delete()
end;

function HasControlPanel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HasControlPanel:keyEvent(unicode, sym, modifier, isDown)
end;

function HasControlPanel:update(dt)		
end;

function HasControlPanel:draw()
end;

function HasControlPanel:onAttach(attacherVehicle)
	
	local panel = attacherVehicle.controlPanel;
	
	if panel ~= nil then
		if panel.loaded == nil then
			-- load,link i3d-File
			local i3dPanel = loadI3DFile(self.controlPanel);
			if i3dPanel ~= 0 then
				link(panel.node, i3dPanel);
				panel.loaded = i3dPanel;
				panel.implement = self;
				self.controlAttacherVehicle = attacherVehicle;
			end;
		end;	
	end;

end;


function HasControlPanel:onDetach()

	if self.controlAttacherVehicle ~= nil then
		local controlPanel = self.controlAttacherVehicle.controlPanel;
		
		if controlPanel ~= nil then
			if controlPanel.implement == self then
				if controlPanel.loaded ~= nil then
					-- delete controlPanel
					delete(controlPanel.loaded);
					controlPanel.loaded = nil;
					controlPanel.implement = nil;
				end;
			end;
		end;
		
		self.controlAttacherVehicle = nil;
	end;

end;
