--
-- silage mode on/off
--
-- 06/08/09 guimchevalier from TSF3 www.tsforum3.com 


RollandT135 = {};

function RollandT135.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function RollandT135:load(xmlFile)
	-- ON
	-- parts visible when silage is on
	self.on = {};
	
	self.on.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.silage.on#count"), 0);
	self.on.capacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.silage.on#capacity"), 0);

    for i=1, self.on.count do
        local nodei = string.format("vehicle.silage.on.node%d", i);
		self.on[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, nodei.."#index"));
    end;
	
	-- graincurve when silage is on
	local grainAnimCurve = AnimCurve:new(linearInterpolator4);
	local keyI = 0;
	while true do
		local key = string.format("vehicle.silage.on.key(%d)", keyI);
		local t = getXMLFloat(xmlFile, key.."#time");
		local yValue = getXMLFloat(xmlFile, key.."#y");
		local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
			break;
		end;
		grainAnimCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
		keyI = keyI +1;
	end;
	if keyI > 0 then
		self.on.grainAnimCurve = grainAnimCurve;
	end;
	
	-- OFF
	-- parts visible when silage is off
	self.off = {};
	
	self.off.count = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.silage.off#count"), 0);
	self.off.capacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.silage.off#capacity"), 0);
    for i=1, self.off.count do
        local nodei = string.format("vehicle.silage.off.node%d", i);
		self.off[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, nodei.."#index"));
    end;
	
	-- graincurve when silage is off
	local grainAnimCurve = AnimCurve:new(linearInterpolator4);
	local keyI = 0;
	while true do
		local key = string.format("vehicle.silage.off.key(%d)", keyI);
		local t = getXMLFloat(xmlFile, key.."#time");
		local yValue = getXMLFloat(xmlFile, key.."#y");
		local scaleX,scaleY,scaleZ = Utils.getVectorFromString(getXMLString(xmlFile, key.."#scale"));
		if y == nil or scaleX == nil or scaleY == nil or scaleZ == nil then
			break;
		end;
		grainAnimCurve:addKeyframe({x=scaleX, y=scaleY, z=scaleZ, w=yValue, time = t});
		keyI = keyI +1;
	end;
	if keyI > 0 then
		self.off.grainAnimCurve = grainAnimCurve;
	end;

	-- bquille
	local translationNodeBequille = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationBequille#index"));
    if translationNodeBequille ~= nil then
        self.translationBequille = {};
        self.translationBequille.node = translationNodeBequille;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationBequille#minTrans"));
        self.translationBequille.minTrans = {};
        self.translationBequille.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationBequille.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationBequille.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationBequille#maxTrans"));
		if x== nil then
		print("nil");
		end;
        self.translationBequille.maxTrans = {};
        self.translationBequille.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationBequille.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationBequille.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationBequille.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationBequille#transTime"), 2)*1000;
    end; 	
	
	-- KEY
	self.keys = {};
	self.keysName = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
		self.keysName[inputName] = Utils.getNoNil(getXMLString(xmlFile, baseName.."#keyname"),"Touche ?");
        i = i+1;
    end;
	
	-- first start
	self.silage = false;
	self.capacity = self.off.capacity;
	self.grainAnimCurve = self.off.grainAnimCurve;
end;

function RollandT135:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	--load function
	local fillLevel = getXMLFloat(xmlFile, key.."#fillLevel");
    local fillType = getXMLString(xmlFile, key.."#fillType");
    self.silage =  Utils.getNoNil(getXMLBool(xmlFile, key.."#silage"),false);
	if self.silage then
		self.capacity = self.on.capacity;
		self.grainAnimCurve = self.on.grainAnimCurve;
	else
		self.capacity = self.off.capacity;
		self.grainAnimCurve = self.off.grainAnimCurve;
	end;
    if fillLevel ~= nil and fillType ~= nil then
        local fillTypeDesc = FruitUtil.fruitTypes[fillType];
        if fillTypeDesc ~= nil then
            self:setFillLevel(fillLevel, fillTypeDesc.index);
        end;
    end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function RollandT135:getSaveAttributesAndNodes(nodeIdent)
	-- save function
	local silagetext='error';
	if self.silage then
		silagetext='true';
	else
		silagetext='false';
	end;
    local attributes = 'silage="'..silagetext..'"';
   return attributes, nil;
end;

function RollandT135:delete()

end;

function RollandT135:mouseEvent(posX, posY, isDown, isUp, button)

end;

function RollandT135:keyEvent(unicode, sym, modifier, isDown)
	-- on/off
	if self.fillLevel == 0 and sym == self.keys.silage and isDown then
		self.silage = not self.silage;
	end;
end;

function RollandT135:update(dt)
	--capacity grainplane
	if self.fillLevel==0 then
		if self.silage then
			self.capacity = self.on.capacity;
			self.grainAnimCurve = self.on.grainAnimCurve;
		else
			self.capacity = self.off.capacity;
			self.grainAnimCurve = self.off.grainAnimCurve;
		end;
	end;
	-- visibility
	for i=1, self.on.count do
		setVisibility(self.on[i], self.silage);
	end;
	
	for i=1, self.off.count do
		setVisibility(self.off[i], not self.silage);
	end;
	
	-- bquille
	local doTranslate = self.translationMaxBequille or self.translationMinBequille;
	if self.translationBequille ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationBequille.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationBequille.maxTrans, self.translationBequille.minTrans, 3, self.translationBequille.transTime, dt, not self.translationMaxBequille); 
		setTranslation(self.translationBequille.node, unpack(newTrans)); 
	end;
end;

function RollandT135:draw()
	if self.fillLevel == 0 then
		if self.silage then
			g_currentMission:addExtraPrintText(string.format("%s : Dmonter les rehausses a ensilage",self.keysName.silage));
		else
			g_currentMission:addExtraPrintText(string.format("%s : Monter les rehausses a ensilage",self.keysName.silage));
		end;
	end;
end;

function RollandT135:onDetach()
	self.translationMaxBequille = false;
	self.translationMinBequille = true; 
end;

function RollandT135:onAttach()
	self.translationMaxBequille = true;
	self.translationMinBequille = false; 
end;
