--
-- mooringblocks
--
-- @author  Geri-G
-- @date  31/07/10
--
-- Copyright (C) Geri-G

baleMode = {};

function baleMode.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function baleMode:load(xmlFile)
	self.enabledFillNodeCollision = {};
	
	local i = 0;
	while true do
		local baseString = string.format("vehicle.fillnodecollisions.fillnodecollision(%d)",i);
		local nodeStrg = getXMLString(xmlFile,baseString.."#node");
		if nodeStrg == nil then
			break;
		end;
		local entry = {};
		
		entry.node = Utils.indexToObject(self.components, nodeStrg);
		table.insert(self.enabledFillNodeCollision,entry);
		setRigidBodyType(entry.node, "Dynamic")
		setCollisionMask(entry.node, 8397058)
		setMass(entry.node, 0.001)
		i = i+1;
	end;	
	self.changeCollision = baleMode.changeCollision;
	
	--self:changeCollision(false);
end;

function baleMode:mouseEvent(posX, posY, isDown, isUp, button)
end;

function baleMode:keyEvent(unicode, sym, modifier, isDown)
end;

function baleMode:update(dt)
	if self.varBody.activeIdx == 4 then
		self:changeCollision(true);
	else
		self:changeCollision(false);
	end;
end;
function baleMode:draw()

end;

function baleMode:changeCollision(enabled)

	if enabled == false then	
		for k,v in pairs(self.enabledFillNodeCollision) do
			setVisibility(v.node, true);
			setRigidBodyType(v.node, "Dynamic")
			setCollisionMask(v.node, 8397058)
			setMass(entry.node, 0.001)
		end;
	elseif enabled == true then
		for k,v in pairs(self.enabledFillNodeCollision) do
			setVisibility(v.node, false);
			setRigidBodyType(v.node,"None");
		end;
	end;
end;

function baleMode:delete()
	for k,v in pairs(self.enabledFillNodeCollision) do
		setVisibility(v.node, false);
		setRigidBodyType(v.node,"None");
		delete(v.node);
	end;
end;