
-- Convert by schlosserhansel 
-- date:28.02.2011

Convert = {};

function Convert.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Convert:load(xmlFile)
	self.currentFillType = fillType;
	self.convertModeGrass = false
	self.convertModeChaff = false
end;
function Convert:delete()
end;

function Convert:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Convert:keyEvent(unicode, sym, modifier, isDown)
end;

function Convert:draw()
	if self.currentFillType == Fillable.FILLTYPE_SILO then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CONVERTGRASS"), self.typeDesc), InputBinding.CONVERTGRASS);
	end;
	if self.currentFillType == Fillable.FILLTYPE_SILO then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CONVERTCHAFF"), self.typeDesc), InputBinding.CONVERTCHAFF);
	end;
	if self.convertModeGrass then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CONVERTOFF"), self.typeDesc), InputBinding.CONVERTOFF);
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("CONVERTMODEGRASS"), self.typeDesc));
	end;
	if self.convertModeChaff then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CONVERTOFF"), self.typeDesc), InputBinding.CONVERTOFF);
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("CONVERTMODECHAFF"), self.typeDesc));
	end;
end;

function Convert:update(dt)	
    if self:getIsActive() then		
		
		if self.currentFillType == Fillable.FILLTYPE_SILO and InputBinding.hasEvent(InputBinding.CONVERTGRASS) then
                    self.currentFillType = Fillable.FILLTYPE_GRASS
					self.convertModeChaff = false
					self.convertModeGrass = true
		end;
		if self.currentFillType == Fillable.FILLTYPE_SILO and InputBinding.hasEvent(InputBinding.CONVERTCHAFF) then
					self.currentFillType = Fillable.FILLTYPE_CHAFF
					self.convertModeGrass = false
					self.convertModeChaff = true					
		end;
		if self.currentFillType == Fillable.FILLTYPE_SILO then
			if self.fillLevel == self.capacity then
				if self.convertModeGrass then
                    self.currentFillType = Fillable.FILLTYPE_GRASS
				end;
			end;
		end;
		if self.currentFillType == Fillable.FILLTYPE_SILO then
			if self.fillLevel == self.capacity then
				if self.convertModeChaff then
                    self.currentFillType = Fillable.FILLTYPE_CHAFF
				end;
			end;
		end;
		if InputBinding.hasEvent(InputBinding.CONVERTOFF) then
			self.convertModeGrass = false
			self.convertModeChaff = false
		end;
	end;
end;

function Convert:updateTick()
end;