-- Fortuna
-- 
--
-- @ Autor  FireAndIce (www.bm-modding.de)
-- @ Last Edit  20/12/2012

Fortuna = {};

function Fortuna.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations); 
end;

function Fortuna:load(xmlFile)
	self.axle1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index1"));
	self.axle2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index2"));
end;

function Fortuna:delete()
end;

function Fortuna:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fortuna:keyEvent(unicode, sym, modifier, isDown)
end;

function Fortuna:update(dt)
	if self:getIsActive() and self.movingDirection ~= 0 then
		xr1,_,_ = getRotation(self.axle1);
		xr2,_,_ = getRotation(self.axle2);
		xrw1,yrw1,zrw1 = getRotation(self.wheels[1].repr);
		xrw2,yrw2,zrw2 = getRotation(self.wheels[2].repr);
		xrw3,yrw3,zrw3 = getRotation(self.wheels[3].repr);
		xrw4,yrw4,zrw4 = getRotation(self.wheels[4].repr);
		self.newRot1 = zrw1 - xr1;
		self.newRot2 = zrw3 - xr2;
		setRotation(self.wheels[1].repr, xrw1,yrw1,self.newRot1)
		setRotation(self.wheels[2].repr, xrw2,yrw2,self.newRot1)
		setRotation(self.wheels[3].repr, xrw3,yrw3,self.newRot2)
		setRotation(self.wheels[4].repr, xrw4,yrw4,self.newRot2)
	end;
	
	setJointFrame(self.componentJoints[2].jointIndex, 0, self.componentJoints[2].jointNode);
end;

function Fortuna:updateTick(dt)

end;

function Fortuna:draw()
		
end;

function Fortuna:onAttach()

end;

function Fortuna:onDetach()
end;