VariableBodyEvent = {};
VariableBodyEvent_mt = Class(VariableBodyEvent, Event);

InitEventClass(VariableBodyEvent, "VariableBodyEvent");

function VariableBodyEvent:emptyNew()
    local self = Event:new(VariableBodyEvent_mt);
    self.className="VariableBodyEvent";
    return self;
end;

function VariableBodyEvent:new(vehicle, state, state2)
    local self = VariableBodyEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	self.state2 = state2;
    return self;
end;

function VariableBodyEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadInt8(streamId);
	self.state2 = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function VariableBodyEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.state);
	streamWriteInt8(streamId, self.state2);
end;

function VariableBodyEvent:run(connection)
	--print("VariableBodyEvent:run(connection)");
    self.vehicle:changeVariableBody(self.state, self.state2, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(VariableBodyEvent:new(self.vehicle, self.state, self.state2), nil, connection, self.vehicle);
    end;
end;

function VariableBodyEvent.sendEvent(vehicle, state, state2, noEventSend)
	--print("VariableBodyEvent.sendEvent(vehicle, state, noEventSend)");
	if vehicle == nil then
		print("--------> VariableBody erRoR :/ ");
	end;
    if state ~= vehicle.varBody.activeIdx or state2 ~= vehicle.varBody.activeSubIdx then
	    if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(VariableBodyEvent:new(vehicle, state, state2), nil, nil, vehicle);
            else
                g_client:getServerConnection():sendEvent(VariableBodyEvent:new(vehicle, state, state2));
            end;
        end;
    end;
end;

