--
-- Worklights
-- This is the specialization for Worklights
--
-- M@D Author  Headshot XXL
-- M@D date 17.07.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

Worklights = {};

function Worklights.prerequisitesPresent(specializations)
    return true;
end;

function Worklights:load(xmlFile)

	self.workLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLights#index"));
	self.workLight2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workLights#index2"));
	
	self.workLightVis = false;
	self.workLight2Vis = false;
	
end;

function Worklights:delete()
end;

function Worklights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Worklights:keyEvent(unicode, sym, modifier, isDown)
end;

function Worklights:update(dt)

	if self.isEntered then
		if self.workLight ~= nil then
			if InputBinding.hasEvent(InputBinding.HAECKSLERWORKLIGHT) then
				self.workLightVis = not self.workLightVis;
			end;
		end;
		if self.workLight2 ~= nil then
			if InputBinding.hasEvent(InputBinding.HAECKSLERWORKLIGHT2) then
				self.workLight2Vis = not self.workLight2Vis;
			end;
		end;
		
	end;
	
	if self.workLight ~= nil then
		setVisibility(self.workLight, self.workLightVis);
	end;
	if self.workLight2 ~= nil then
		setVisibility(self.workLight2, self.workLight2Vis);
	end;


end;

function Worklights:draw()

	if self.workLight ~= nil and self.workLight2 ~= nil then
		g_currentMission:addExtraPrintText("Arbeitslicht Taste: " ..InputBinding.getKeyNamesOfDigitalAction(InputBinding.HAECKSLERWORKLIGHT).. " 2. Arbeitslicht Taste: ".. InputBinding.getKeyNamesOfDigitalAction(InputBinding.HAECKSLERWORKLIGHT2));
	elseif self.workLight ~= nil and not self.workLight2 ~= nil then
		g_currentMission:addExtraPrintText("Arbeitslicht Taste:" ..InputBinding.getKeyNamesOfDigitalAction(InputBinding.HAECKSLERWORKLIGHT));
	elseif not self.workLight ~= nil and self.workLight2 ~= nil then
		g_currentMission:addExtraPrintText("2. Arbeitslicht Taste:" ..InputBinding.getKeyNamesOfDigitalAction(InputBinding.HAECKSLERWORKLIGHT2));
	end;

end;
