﻿--
-- Kockerling Jockey 600
--
-- author  Mythos
-- date  02/01/2014
-- www.ARM-team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

Jockey600 = {};

function Jockey600.prerequisitesPresent(specializations)
	return true;
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:load(xmlFile)

	-- Functions
	self.MPCode = SpecializationUtil.callSpecializationsFunction("MPCode");
	
	-- Indexs
	self.attachedHyd = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.attachedHyd#index"));
	self.detachedHyd = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.detachedHyd#index"));
	self.Nsupport = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Nsupport#index"));
	self.OBsupport = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.OBsupport#index"));
	
	self.HydAnimJoint = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.HydAnimJoint#index"));
	self.HydAnimRef = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.HydAnimRef#index"));
	self.HydAnimRef1 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.HydAnimRef1#index"));
	
	-- Animations
	self.coverMode = getXMLString(xmlFile, "vehicle.coverMode#animationName");
	
	-- Particles
	self.leftPS = {};
    local key = string.format("vehicle.leftPS");
	local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#node"));
    Utils.loadParticleSystem(xmlFile, self.leftPS, key, node, false, nil, self.baseDirectory)
	
	self.rightPS = {};
    local key = string.format("vehicle.rightPS");
	local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#node"));
    Utils.loadParticleSystem(xmlFile, self.rightPS, key, node, false, nil, self.baseDirectory)
	
	self.middlePS = {};
    local key = string.format("vehicle.middlePS");
	local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#node"));
    Utils.loadParticleSystem(xmlFile, self.middlePS, key, node, false, nil, self.baseDirectory)

	-- Booleans
	self.stateCV = false;
	self.previousLevel = 0;

end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:delete()
	Utils.deleteParticleSystem(self.leftPS);
	Utils.deleteParticleSystem(self.rightPS);
	Utils.deleteParticleSystem(self.middlePS);
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:mouseEvent(posX, posY, isDown, isUp, button)
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:keyEvent(unicode, sym, modifier, isDown)
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:update(dt)
	
	if self:getIsActiveForInput() and self:getIsActive() then

		if InputBinding.hasEvent(InputBinding.Jockey600_COVER_MODE) then
			self:MPCode(2, not self.stateCV);
		end;

	end;

end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:updateTick(dt)
	if self:getIsActive() then
		
		self:MPCode(1);

		if self.isTurnedOn and self.sowingMachineHasGroundContact and self.movingDirection > 0 and self.fillLevel ~= self.previousLevel and not self.isSowingMachineFilling then
			Utils.setEmittingState(self.leftPS, true);
			Utils.setEmittingState(self.rightPS, true);
			Utils.setEmittingState(self.middlePS, true);
			self.previousLevel = self.fillLevel;
			
		else
			Utils.setEmittingState(self.leftPS, false);
			Utils.setEmittingState(self.rightPS, false);
			Utils.setEmittingState(self.middlePS, false);
			
		end;
		
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:MPCode(mode, state, noEventSend)
	Jockey600Event.sendEvent(self, mode, state, noEventSend);

--______________________________________________________________________________
	if mode == 1 then
--___________________________________  HYD ANGLE   ________________________________
		local x,y,z = localDirectionToWorld(self.HydAnimRef, 0, 0, 1);
        local length = Utils.vector2Length(x,z);
        if (length ~= 0.0) then
            self.angle1 = math.deg(math.atan2(z/length,x/length)) + 90.0;
            while (self.angle1 > 359.999999) do
                self.angle1 = self.angle1 - 360.0;
            end;
            while (self.angle1 < 0.0) do
                self.angle1 = self.angle1 + 360.0;
            end;
		end;
		
		local x1,y1,z1 = localDirectionToWorld(self.HydAnimRef1, 0, 0, 1);
        local length = Utils.vector2Length(x1,z1);
        if (length ~= 0.0) then
            self.angle2 = math.deg(math.atan2(z1/length,x1/length)) + 90.0;
            while (self.angle2 > 359.999999) do
                self.angle2 = self.angle2 - 360.0;
            end;
            while (self.angle2 < 0.0) do
                self.angle2 = self.angle2 + 360.0;
            end;
		end;
		self.diff = math.rad(self.angle1) - math.rad(self.angle2);
		setRotation(self.HydAnimJoint, 0, -self.diff, 0);
--______________________________________________________________________________
	elseif mode == 2 then
--___________________________________ COVER MODE    _______________________________
		if state then
			self:playAnimation(self.coverMode, 1, nil, true);
			self.stateCV = true;
		else
			self:playAnimation(self.coverMode, -1, nil, true);
			self.stateCV = false;
		end;
	end;

end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:draw()

	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("Jockey600_COVER_MODE"), self.typeDesc), InputBinding.Jockey600_COVER_MODE);
	
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:onAttach(attacherVehicle)
	setVisibility(self.detachedHyd, false);
	setVisibility(self.Nsupport, false);
	setVisibility(self.attachedHyd, true);
	setVisibility(self.OBsupport, true);
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:onDetach()
	setVisibility(self.detachedHyd, true);
	setVisibility(self.Nsupport, true);
	setVisibility(self.attachedHyd, false);
	setVisibility(self.OBsupport, false);
	Utils.setEmittingState(self.leftPS, false);
	Utils.setEmittingState(self.rightPS, false);
	Utils.setEmittingState(self.middlePS, false);
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		self.stateCV = Utils.getNoNil(getXMLBool(xmlFile, key.."#stateCV"),false);
		self:MPCode(2, self.stateCV);
	end;

	return BaseMission.VEHICLE_LOAD_OK;
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'stateCV="'..tostring(self.stateCV)..'"';
	
	local nodes = nil;
	
	return attributes,nodes;
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:readStream(streamId, connection)
	self.stateCV = streamReadBool(streamId);
end;

--________________________________________________________________________________________________________________________________________________________
function Jockey600:writeStream(streamId, connection)
	streamWriteBool(streamId, self.stateCV);
end;

--**********************************************************************************************************************************************************************************
Jockey600Event = {};
Jockey600Event_mt = Class(Jockey600Event, Event);

InitEventClass(Jockey600Event, "Jockey600Event");

function Jockey600Event:emptyNew()
    local self = Event:new(Jockey600Event_mt);
    self.className="Jockey600Event";
    return self;
end;

function Jockey600Event:new(vehicle, mode, state)
    local self = Jockey600Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
	self.state = state;
    return self;
end;

function Jockey600Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function Jockey600Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt32(streamId, self.mode);
	streamWriteBool(streamId, self.state);
end;

function Jockey600Event:run(connection)
	self.vehicle:MPCode(self.mode, self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(Jockey600Event:new(self.vehicle, self.mode, self.state), nil, connection, self.vehicle);
    end;
end;

function Jockey600Event.sendEvent(vehicle, mode, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(Jockey600Event:new(vehicle, mode, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(Jockey600Event:new(vehicle, mode, state));
		end;
	end;
end;