--
-- dynamicRoll
-- Specialization for dynamicRoll
--
-- @author  	Manuel Leithner
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
-- @date		15/09/13
-- 				V1.5 - Edit by Michi77: Enables manual set of reelSpeed.
--
-- free for noncommerical-usage
--

dynamicRoll = {};

function dynamicRoll.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function dynamicRoll:load(xmlFile)
	self.conspeed = {};
	self.conspeed.speedScaleTime = 5000;
	self.conspeed.speed = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.conspeed#speed"), 11);
	self.conspeed.rollSpeedBackup = self.rollNodes[1].speed;
	for _, rollNode in pairs(self.rollNodes) do
		rollNode.backup = rollNode.speed;
		rollNode.speed = 0;
	end;
	self.startThreshingBackup = nil;
	
end;

function dynamicRoll:delete()
end;

function dynamicRoll:readStream(streamId, connection)
end;

function dynamicRoll:writeStream(streamId, connection)
end;

function dynamicRoll:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dynamicRoll:keyEvent(unicode, sym, modifier, isDown)
end;

function dynamicRoll:update(dt)
	if self:getIsActive() and self.reelStarted then	
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.conspeed.speed, 1.5));
	
		for _, rollNode in pairs(self.rollNodes) do
			local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.conspeed.speedScaleTime, dt, false);
			rollNode.speed = rollSpeed[1];
		end;
	else
		if self.rollNodes[1].speed ~= 0 then
			local percent = math.max(0.85, math.min((self.lastSpeed*3600) / self.conspeed.speed, 1.5));
		
			for _, rollNode in pairs(self.rollNodes) do
				local rollSpeed = Utils.getMovedLimitedValues({rollNode.speed}, {rollNode.backup * percent}, {0}, 1, self.conspeed.speedScaleTime*1.5, dt, true);
				rollNode.speed = rollSpeed[1];
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;
		end;
	end;
	if self.reelStarted then
		if self:getIsActive() and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() and InputBinding.hasEvent(InputBinding.SpeedUp) then
			self.reelSpeed = self.reelSpeed + 0.0005
		elseif self:getIsActive() and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() and InputBinding.hasEvent(InputBinding.SpeedDown) then
			self.reelSpeed = self.reelSpeed - 0.0005
		end;
	end;
end;

function dynamicRoll:updateTick(dt)
end;

function dynamicRoll:draw()
	if self.reelStarted then
        g_currentMission:addHelpButtonText(g_i18n:getText("SpeedUp"), InputBinding.SpeedUp);
	end;
    if self.reelStarted then
        g_currentMission:addHelpButtonText(g_i18n:getText("SpeedDown"), InputBinding.SpeedDown);
    end;
end;

function dynamicRoll:startThreshing()
end;

function dynamicRoll:stopThreshing()
end;

function dynamicRoll:onAttach()
end;

function dynamicRoll:onDetach()	
end; 