--
-- Tieflader
-- Specialization for a Tieflader
--
-- @author  mx270
-- @date  29/07/11

-- Copyright  mx270, www.modding-society.de

Tieflader = {};

function Tieflader.prerequisitesPresent(specializations)
    return true;
end;

function Tieflader:load(xmlFile)	
	self.Spanngurt = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.Spanngurt#index"));
	self.BEL = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.BEL#index"));
	
	self.PlayerTriggerCallback = Tieflader.PlayerTriggerCallback;
	self.trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PlayerTrigger#index"));	
	addTrigger(self.trigger, "PlayerTriggerCallback", self);
    self.deleteListenerId = addDeleteListener(self.trigger, "delete", self);

	self.PlayerinTrigger = false;
	setVisibility(self.BEL, false);

	self.RotComp = {getWorldRotation(self.components[3].node)};
end;

function Tieflader:delete()
    removeTrigger(self.trigger);
    removeDeleteListener(self.trigger, self.deleteListenerId);
end;

function Tieflader:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Tieflader:keyEvent(unicode, sym, modifier, isDown)
end;

function Tieflader:update(dt)

	local x,y,z = getWorldRotation(self.components[3].node);
	if x ~= self.RotComp[1] or y ~= self.RotComp[2] or z ~= self.RotComp[3] then
		self.RotComp = {x,y,z};
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;

	if self.animationParts[1].clipStartTime then 
		setVisibility(self.Spanngurt, true);
	else
		setVisibility(self.Spanngurt, false);
	end;
	
	if self.animationParts[1].clipEndTime then 
		setJointRotationLimit(self.componentJoints[5].jointIndex, 0, true, Utils.degToRad(-40), Utils.degToRad(40));
		setJointRotationLimit(self.componentJoints[6].jointIndex, 0, true, Utils.degToRad(-40), Utils.degToRad(40));
	else 
		setJointRotationLimit(self.componentJoints[5].jointIndex, 0, true, Utils.degToRad(-0), Utils.degToRad(0));
		setJointRotationLimit(self.componentJoints[6].jointIndex, 0, true, Utils.degToRad(-0), Utils.degToRad(0));
	end;
	
	if self.PlayerinTrigger == true then 
		
		if InputBinding.hasEvent(InputBinding.TIEFLADER_1) then
			if self.Upper then
				self:setAnimationTime(1, self.animationParts[1].offSet, false);
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration, false);
			end;
		end;

		if self.Upper then
			g_currentMission:addHelpButtonText(g_i18n:getText("Tieflader_1"), InputBinding.TIEFLADER_1);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Tieflader_2"), InputBinding.TIEFLADER_1);
		end;	
	
	end;
	
	self.Upper = self.animationParts[1].clipEndTime and self.animationParts[1].inputDone;
end;



function Tieflader:updateTick(dt)
 end;
 
function Tieflader:PlayerTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter or onStay then
		if (g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) then
			self.PlayerinTrigger = true;
			end;
		elseif onLeave then
			self.PlayerinTrigger = false;
	end;

end;

function Tieflader:onAttach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-65), Utils.degToRad(65));	
	setVisibility(self.BEL, true);
end;

function Tieflader:onDetach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-1), Utils.degToRad(1));
	setVisibility(self.BEL, false);
end;

function Tieflader:draw()
end;
