--[[
 Traffic Pack Loader
 Edit by fin050808/unitedtrafficteam
 Date 03.02.2014
]]--
function TrafficVehicle:load(xmlFile)
  self.justStarted = true
  self.isSunOn = false
  self.isNiceWeather = false
  self.lightsId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lights#groupIndex"))
  self.lightsId2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightsPrizep#groupIndex"))
  self.lightsId3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightsPrizepMTZ#groupIndex"))
  local colorNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.colors#index"))
  if colorNode ~= nil then
    local colors = {}
    table.insert(colors, {1,1,1})
    local i = 0
    while true do
        local key = string.format("vehicle.colors.color(%d)", i)
        local rgb = getXMLString(xmlFile, key .. "#rbg")
        if rgb == nil then
          break
        end
        local r, g, b = Utils.getVectorFromString(rgb)
        if r ~= nil and g ~= nil and b ~= nil then
          table.insert(colors, {r,g,b})
        end
        i = i + 1
    end
    local index = math.random(1, table.getn(colors))
    setShaderParameter(colorNode, "partScale", colors[index][1], colors[index][2], colors[index][3], 0, false)
  end

    if Utils.endsWith(self.configFileName, "/TrafficPack/cola/cola.xml") then	
		self.motorSound2 = Utils.getFilename("Sourse/cola.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound2, 25, 3, 2, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/TNT/TNT.xml") then	
		self.motorSound2 = Utils.getFilename("Sourse/TNT.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound2, 25, 3, 2, 0);
		
	else
		self.soundId = createAudioSource("trafficSample", "data/vehicles/cars/carSound.wav", 25, 2, 1, 0) --     
	end	
	link(self.components[1].node, self.soundId);	
end
function TrafficVehicle:delete()
end
function TrafficVehicle:mouseEvent(posX, posY, isDown, isUp, button)
end
function TrafficVehicle:keyEvent(unicode, sym, modifier, isDown)
end
function TrafficVehicle:update(dt)
    if self.justStarted or self.isSunOn ~= g_currentMission.environment.isSunOn or self.isNiceWeather ~= (g_currentMission.environment.currentRain == nil) then
        self.isSunOn = g_currentMission.environment.isSunOn;
		self.isNiceWeather = g_currentMission.environment.currentRain == nil;
		self.justStarted = false;
        setVisibility(self.lightsId, not (self.isSunOn and self.isNiceWeather)); 
        setVisibility(self.lightsId2, not (self.isSunOn and self.isNiceWeather));
        setVisibility(self.lightsId3, not (self.isSunOn and self.isNiceWeather));
    end;
end
function TrafficVehicle:draw()
end