--
-- LemkenAlbatros60
-- Specialization for LemkenAlbatros60
--
-- @author Felix "Outlaw" Sorge
-- @date  29/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--


LemkenAlbatros60 = {};

function LemkenAlbatros60.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function LemkenAlbatros60:load(xmlFile)

	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {}
	self.collisionArm = {}; 
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
	end; 
	
	local transBackNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.transBack#index"));
    if transBackNode ~= nil then
        self.transBack = {};
        self.transBack.node = transBackNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transBack#minTrans"));
        self.transBack.minTrans = {};
        self.transBack.minTrans[1] = Utils.getNoNil(x, 0);
        self.transBack.minTrans[2] = Utils.getNoNil(y, 0);
        self.transBack.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transBack#maxTrans"));
        self.transBack.maxTrans = {};
        self.transBack.maxTrans[1] = Utils.getNoNil(x, 0);
        self.transBack.maxTrans[2] = Utils.getNoNil(y, 0);
        self.transBack.maxTrans[3] = Utils.getNoNil(z, 0);
        self.transBack.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.transBack#transTime"), 2)*1000;
    end;
	
		local transBack2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.transBack2#index"));
    if transBack2Node ~= nil then
        self.transBack2 = {};
        self.transBack2.node = transBack2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transBack2#minTrans"));
        self.transBack2.minTrans = {};
        self.transBack2.minTrans[1] = Utils.getNoNil(x, 0);
        self.transBack2.minTrans[2] = Utils.getNoNil(y, 0);
        self.transBack2.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.transBack2#maxTrans"));
        self.transBack2.maxTrans = {};
        self.transBack2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.transBack2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.transBack2.maxTrans[3] = Utils.getNoNil(z, 0);
        self.transBack2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.transBack2#transTime"), 2)*1000;
    end;
	
	self.dustParticleSystems = {};
    local dustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.dustParticleSystems#count"), 0);
    for i=1, dustParticleSystemCount do
        local namei = string.format("vehicle.dustParticleSystems.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.dustParticleSystems, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
	local spraySound = getXMLString(xmlFile, "vehicle.spraySound#file");
    if spraySound ~= nil and spraySound ~= "" then
        spraySound = Utils.getFilename(spraySound, self.baseDirectory);
        self.spraySound = createSample("spraySound");
        self.spraySoundEnabled = false;
        loadSample(self.spraySound, spraySound, false);
        self.spraySoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySound#pitchOffset"), 1);
        self.spraySoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.spraySound#volume"), 1);
    end;
	
	
	
	self.dischargeSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.dischargeSpeed#value"), 1);
	self.groundCheck = {};
	self.groundCheck.left = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#left"));
	self.groundCheck.right = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.groundCheck#right"));
	
	self.keyType = InputBinding.getButtonKeyName;
	self.keyName = "Taste"; 
	
	if g_settingsJoystickEnabled then 
		self.keySet = not self.keySet;
	end; 
	
end;



function LemkenAlbatros60:update(dt)

	if self.attacherVehicle then

		self.translationMax = false;
		self.translationMin = false;
		if InputBinding.isPressed(InputBinding.LemkenAlbatros60_up) and self.CheckDone.transport and not self.levelCheck and self.Go.transport then
			self.translationMax = true;
		end;
		
		if InputBinding.isPressed(InputBinding.LemkenAlbatros60_down) and self.CheckDone.transport and not self.levelCheck and self.Go.transport then
			self.translationMin = true;
		end;
		
		if InputBinding.hasEvent(InputBinding.LemkenAlbatros60_Transport) and self.trspCheck and not self.turnOn and not self.levelCheck then
			self.Go.transport = not self.Go.transport; 
			self.Done.transport = true; 
			self.Go.larm1 = not self.Go.larm1; 
			self.Done.larm1 = true; 
			self.Go.larm2 = not self.Go.larm2; 
			self.Done.larm2 = true; 
			self.Go.larm3 = not self.Go.larm3; 
			self.Done.larm3 = true; 
			self.Go.rarm1 = not self.Go.rarm1; 
			self.Done.rarm1 = true; 
			self.Go.rarm2 = not self.Go.rarm2; 
			self.Done.rarm2 = true; 
			self.Go.rarm3 = not self.Go.rarm3; 
			self.Done.rarm3 = true; 
		end; 
		
		if InputBinding.hasEvent(InputBinding.LemkenAlbatros60_levelcheck) and self.CheckDone.transport and self.Go.transport then
			self.levelCheck = not self.levelCheck; 
		end; 
			
		if InputBinding.hasEvent(InputBinding.LemkenAlbatros60_on) and self.CheckDone.transport and self.fillLevel ~= 0 and self.Go.transport then
			self.turnOn = not self.turnOn; 
			self.distanceCheck = not self.distanceCheck; 
		end; 
		

		
		if self.levelCheck then	
			local x,y,z = getWorldTranslation(self.groundCheck.right);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCr = y-terrainHeight; 
			local x,y,z = getWorldTranslation(self.groundCheck.left);
			local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
			local gCl = y-terrainHeight; 
			self.translationMax = false;
			self.translationMin = false;
			if (math.min(gCl,gCr) < 1.3) then
				self.translationMin = true;
			else
				self.translationMax = true;
			end;	
		end; 		
				

				
		if self.fillLevel == 0 then
		    if self.spraySoundEnabled then
		        stopSample(self.spraySound);
		        self.spraySoundEnabled = false;
			end;
			Utils.setEmittingState(self.dustParticleSystems, false)
			self.turnOn = false; 
		end; 
				
		if self.turnOn then
			Utils.setEmittingState(self.dustParticleSystems, true)
			
			if not self.spraySoundEnabled and self:getIsActiveForSound() then
	            playSample(self.spraySound, 0, self.spraySoundVolume, 0);
	            setSamplePitch(self.spraySound, self.spraySoundPitchOffset);
	            self.spraySoundEnabled = true;
	        end;
			
			local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
			local deltaLevel = FruitUtil.fruitIndexToDesc[self.currentFillType].literPerQm * difficultyMultiplier * self.dischargeSpeed;
			self:setFillLevel(self.fillLevel-deltaLevel, self.currentFillType);
			
			for k,cuttingArea in pairs(self.cuttingAreas) do
                local x,y,z = getWorldTranslation(cuttingArea.start);
                local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                Utils.removeWeedArea(x, z, x1, z1, x2, z2);
            end;
		else
			if self.spraySoundEnabled then
		        stopSample(self.spraySound);
		        self.spraySoundEnabled = false;
			end;
			Utils.setEmittingState(self.dustParticleSystems, false)
		end; 	

				
		local x, y, z = getTranslation(self.transBack.node);
		if self.transBack.minTrans[2] == math.floor(y * 100) / 100 then
			self.trspCheck = true; 
		else
			self.trspCheck = false; 
		end;
		
		
		local doTranslate = self.translationMax or self.translationMin
		if self.transBack ~= nil and doTranslate then
			local x, y, z = getTranslation(self.transBack.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.transBack.maxTrans, self.transBack.minTrans, 3, self.transBack.transTime, dt, not self.translationMax);
			setTranslation(self.transBack.node, unpack(newTrans));
			local x, y, z = getTranslation(self.transBack2.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.transBack2.maxTrans, self.transBack2.minTrans, 3, self.transBack2.transTime, dt, not self.translationMax);
			setTranslation(self.transBack2.node, unpack(newTrans));

			local varName = "larm1"
			local Collision = self.collisionArm[varName];
			setJointFrame(Collision.index, 0, Collision.armAttacher);
			local varName = "larm2"
			local Collision = self.collisionArm[varName];
			setJointFrame(Collision.index, 0, Collision.armAttacher);
			local varName = "larm3"
			local Collision = self.collisionArm[varName];
			setJointFrame(Collision.index, 0, Collision.armAttacher);
			local varName = "rarm1"
			local Collision = self.collisionArm[varName];
			setJointFrame(Collision.index, 0, Collision.armAttacher);
			local varName = "rarm2"
			local Collision = self.collisionArm[varName];
			setJointFrame(Collision.index, 0, Collision.armAttacher);
			local varName = "rarm3"
			local Collision = self.collisionArm[varName];
			setJointFrame(Collision.index, 0, Collision.armAttacher);
		end;
	end; 	

	
	if self.Go.pillar ~= nil and self.Done.pillar ~= false then
		self:anim("pillar", false); 
	end; 
	
	if self.Go.transport ~= nil and self.Done.transport ~= false then
		self:anim("transport", false); 
	end; 
	
	
	if self.Go.larm1 ~= nil and self.Done.larm1 ~= false then
		self:anim("larm1", false); 
	end; 
			
	if self.Go.larm2 ~= nil and self.Done.larm2 ~= false then
		self:anim("larm2", false); 
	end;

	if self.Go.larm3 ~= nil and self.Done.larm3 ~= false then
		self:anim("larm3", false); 
	end;	
	
	if self.Go.rarm1 ~= nil and self.Done.rarm1 ~= false then
		self:anim("rarm1", false); 
	end; 
			
	if self.Go.rarm2 ~= nil and self.Done.rarm2 ~= false then
		self:anim("rarm2", false); 
	end;

	if self.Go.rarm3 ~= nil and self.Done.rarm3 ~= false then
		self:anim("rarm3", false); 
	end;	
				
end;


function LemkenAlbatros60:draw()

	if self.Go.transport and self.trspCheck and not self.turnOn and not self.levelCheck then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.LemkenAlbatros60_Transport).. ": " ..g_i18n:getText("LemkenAlbatros60_1")); 
	elseif self.trspCheck and not self.turnOn and not self.levelCheck then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.LemkenAlbatros60_Transport).. ": " ..g_i18n:getText("LemkenAlbatros60_2")); 
	end; 	
	
	if self.CheckDone.transport and self.Go.transport and not self.levelCheck then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.LemkenAlbatros60_down).. "/" ..self.keyType(InputBinding.LemkenAlbatros60_up).. ": " ..g_i18n:getText("LemkenAlbatros60_5")); 
	end; 
	
	if self.CheckDone.transport and self.Go.transport and self.levelCheck then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.LemkenAlbatros60_levelcheck).. ": " ..g_i18n:getText("LemkenAlbatros60_7")); 
	elseif self.CheckDone.transport and self.Go.transport and not self.levelCheck then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.LemkenAlbatros60_levelcheck).. ": " ..g_i18n:getText("LemkenAlbatros60_6")); 
	end; 
	
	if self.turnOn and self.CheckDone.transport and self.Go.transport and self.fillLevel ~= 0 then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.LemkenAlbatros60_on).. ": " ..g_i18n:getText("LemkenAlbatros60_4")); 
	elseif self.CheckDone.transport and self.Go.transport and self.fillLevel ~= 0 then
		g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.LemkenAlbatros60_on).. ": " ..g_i18n:getText("LemkenAlbatros60_3")); 
	end; 
	
end;


function LemkenAlbatros60:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 


function LemkenAlbatros60:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;


function LemkenAlbatros60:mouseEvent(posX, posY, isDown, isUp, button)
end;


function LemkenAlbatros60:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym==Input.KEY_8 then
		self.keySet = not self.keySet; 
		if self.keySet then
			self.keyType = InputBinding.getButtonName;
			self.keyName = "Button"; 
		else
			self.keyType = InputBinding.getButtonKeyName;
			self.keyName = "Taste"; 
		end; 
	end;
end;


function LemkenAlbatros60:onAttach()
	self.Go.pillar = not self.Go.pillar; 
	self.Done.pillar = true; 
end; 	


function LemkenAlbatros60:onDetach()
	self.Go.pillar = not self.Go.pillar; 
	self.Done.pillar = true; 
	Utils.setEmittingState(self.dustParticleSystems, false)
end;


function LemkenAlbatros60:delete()
	Utils.setEmittingState(self.dustParticleSystems, false)
	Utils.deleteParticleSystem(self.dustParticleSystems)
	removeJoint(self.collisionArm.larm1.index); 
	removeJoint(self.collisionArm.larm2.index); 
	removeJoint(self.collisionArm.larm3.index); 
	removeJoint(self.collisionArm.rarm1.index); 
	removeJoint(self.collisionArm.rarm2.index); 
	removeJoint(self.collisionArm.rarm3.index); 
end;


function LemkenAlbatros60:getSaveAttributesAndNodes(nodeIdent)
	if self.CheckDone.transport then
		trsp = "false";
	else
		trsp = "true";
	end; 
	local attributes = 'transport="'..trsp..'"';
	return attributes, nil;
end;


function LemkenAlbatros60:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local trsp = getXMLString(xmlFile, key.."#transport");
	if trsp == "false" and not resetVehicles then
		self.Go.transport = not self.Go.transport; 
		self.Done.transport = true; 
		self.Go.larm1 = not self.Go.larm1; 
		self.Done.larm1 = true; 
		self.Go.larm2 = not self.Go.larm2; 
		self.Done.larm2 = true; 
		self.Go.larm3 = not self.Go.larm3; 
		self.Done.larm3 = true; 
		self.Go.rarm1 = not self.Go.rarm1; 
		self.Done.rarm1 = true; 
		self.Go.rarm2 = not self.Go.rarm2; 
		self.Done.rarm2 = true; 
		self.Go.rarm3 = not self.Go.rarm3; 
		self.Done.rarm3 = true; 
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;