-- 
-- Greifer Script by Zippo
--


LogGreifer = {};

function LogGreifer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function LogGreifer:load(xmlFile)

	local Collision1 = {};
	Collision1.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision1#collision"));
	Collision1.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision1#collsionAttacher"));
	Collision1.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision1#armAttacher"));
	Collision1.index = 0;
	self.Collision1Base = Collision1;
	
	local Collision2 = {};
	Collision2.collision = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision2#collision"));
	Collision2.collisionAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision2#collsionAttacher"));
	Collision2.armAttacher = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.collision2#armAttacher"));
	Collision2.index = 0;
	self.Collision2Base = Collision2;

	self.collisions = true;


	local Rot1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Rot1#index"));
    if Rot1Node ~= nil then
        self.Rot1 = {};
        self.Rot1.node = Rot1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rot1#minRot"));
        self.Rot1.minRot = {};
        self.Rot1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Rot1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Rot1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rot1#maxRot"));
        self.Rot1.maxRot = {};
        self.Rot1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Rot1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Rot1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Rot1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Rot1#rotTime"), 2)*1000;
    end;
	local Rot2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Rot2#index"));
    if Rot2Node ~= nil then
        self.Rot2 = {};
        self.Rot2.node = Rot2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rot2#minRot"));
        self.Rot2.minRot = {};
        self.Rot2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Rot2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Rot2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rot2#maxRot"));
        self.Rot2.maxRot = {};
        self.Rot2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.Rot2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.Rot2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.Rot2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Rot2#rotTime"), 2)*1000;
    end;
	
	self.keys = {};
	self.keysDesc = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
		self.keysDesc[inputName] = getXMLString(xmlFile, baseName.. "#keyDesc");
        i = i+1;
    end;

hydraOpenSoundFile = Utils.getFilename("hydraopen.wav", self.baseDirectory);
    self.hydraOpenSoundId = createSample("HYDOPEN_hydraOpen");
    loadSample(self.hydraOpenSoundId, hydraOpenSoundFile, false);
    self.hydraOpenPlaying = false;

hydraCloseSoundFile = Utils.getFilename("hydraclose.wav", self.baseDirectory);
    self.hydraCloseSoundId = createSample("HYDCLOSE_hydraClose");
    loadSample(self.hydraCloseSoundId, hydraCloseSoundFile, false);
    self.hydraClosePlaying = false;

end;

function LogGreifer:delete()
end;

function LogGreifer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function LogGreifer:keyEvent(unicode, sym, modifier, isDown)
end;

function LogGreifer:update(dt)
		local CollisionBase1 = self.Collision1Base;
		setJointFrame(CollisionBase1.index, 0, CollisionBase1.armAttacher);
		local CollisionBase2 = self.Collision2Base;
		setJointFrame(CollisionBase2.index, 0, CollisionBase2.armAttacher);

	    if self.collisions then
			self.collisions = false;
			local constr = JointConstructor:new();
			constr:setActors(self.rootNode, self.Collision1Base.collision);
			constr:setJointTransforms(self.Collision1Base.armAttacher, self.Collision1Base.collisionAttacher);
			for i=1, 3 do
				constr:setRotationLimit(i-1, 0, 0, 0);
				constr:setTranslationLimit(i-1, true, 0, 0);
			end;
			self.Collision1Base.index = constr:finalize();

			local constr2 = JointConstructor:new();
			constr2:setActors(self.rootNode, self.Collision2Base.collision);
			constr2:setJointTransforms(self.Collision2Base.armAttacher, self.Collision2Base.collisionAttacher);
			for i=1, 3 do
				constr2:setRotationLimit(i-1, 0, 0, 0);
				constr2:setTranslationLimit(i-1, true, 0, 0);
			end;
			self.Collision2Base.index = constr2:finalize();
		end;

	if self.attacherVehicle ~= nil then
	    if self.attacherVehicle.isEntered then
			if Input.isKeyPressed(self.keys.OPEN_PLIERS) then
				local x, y, z = getRotation(self.Rot1.node);
		        local rot = {x,y,z};
		        local newRot = Utils.getMovedLimitedValues(rot, self.Rot1.maxRot, self.Rot1.minRot, 3, self.Rot1.rotTime*2, dt, true);
			    setRotation(self.Rot1.node, unpack(newRot));
				local x, y, z = getRotation(self.Rot2.node);
		        local rot = {x,y,z};
		        local newRot = Utils.getMovedLimitedValues(rot, self.Rot2.maxRot, self.Rot2.minRot, 3, self.Rot2.rotTime*2, dt, true);
			    setRotation(self.Rot2.node, unpack(newRot));
			if not self.hydraOpenPlaying then
            			playSample(self.hydraOpenSoundId, 0, 1, 0);
            			self.hydraOpenPlaying = true;
        			end;
    			else
        			if self.hydraOpenPlaying then
            			stopSample(self.hydraOpenSoundId);
            			self.hydraOpenPlaying = false;
       			end;
		    end;

			if Input.isKeyPressed(self.keys.CLOSE_PLIERS) then
				local x, y, z = getRotation(self.Rot1.node);
		        local rot = {x,y,z};
		        local newRot = Utils.getMovedLimitedValues(rot, self.Rot1.maxRot, self.Rot1.minRot, 3, self.Rot1.rotTime*2, dt, false);
			    setRotation(self.Rot1.node, unpack(newRot));
				local x, y, z = getRotation(self.Rot2.node);
		        local rot = {x,y,z};
		        local newRot = Utils.getMovedLimitedValues(rot, self.Rot2.maxRot, self.Rot2.minRot, 3, self.Rot2.rotTime*2, dt, false);
			    setRotation(self.Rot2.node, unpack(newRot));
			if not self.hydraClosePlaying then
            			playSample(self.hydraCloseSoundId, 0, 1, 0);
            			self.hydraClosePlaying = true;
        			end;
    			else
        			if self.hydraClosePlaying then
            			stopSample(self.hydraCloseSoundId);
            			self.hydraClosePlaying = false;
       			end;
		    end;
		end;
	end;
	
end;


function LogGreifer:draw()
	g_currentMission:addExtraPrintText("" .. self.keysDesc.OPEN_PLIERS .. " Open Pliers");
	g_currentMission:addExtraPrintText("" .. self.keysDesc.CLOSE_PLIERS .. " Close Pliers");
end;